/*
 * Decompiled with CFR 0.152.
 */
package smartrics.iotics.connectors.twins;

import com.google.common.collect.Lists;
import com.iotics.api.FeedID;
import com.iotics.api.ShareFeedDataRequest;
import com.iotics.api.TwinID;
import com.iotics.api.UpsertTwinRequest;
import java.util.ArrayList;
import java.util.List;
import smartrics.iotics.connectors.twins.AnnotationToApiBuilder;
import smartrics.iotics.connectors.twins.Identifiable;
import smartrics.iotics.connectors.twins.Mapper;
import smartrics.iotics.host.Builders;
import smartrics.iotics.identity.Identity;

public interface AnnotationMapper
extends Mapper,
Identifiable {
    @Override
    default public List<ShareFeedDataRequest> getShareFeedDataRequest() {
        AnnotationToApiBuilder builder = new AnnotationToApiBuilder();
        List<AnnotationToApiBuilder.FeedValue> feedPayloads = builder.buildShareFeedDataRequestJSONPayload(this);
        ArrayList results = Lists.newArrayListWithCapacity((int)feedPayloads.size());
        feedPayloads.forEach(fp -> {
            ShareFeedDataRequest request = ShareFeedDataRequest.newBuilder().setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity())).setArgs(ShareFeedDataRequest.Arguments.newBuilder().setFeedId(FeedID.newBuilder().setId(fp.feedId()).setTwinId(this.getMyIdentity().did()).build()).build()).setPayload(fp.payload()).build();
            results.add(request);
        });
        return results;
    }

    @Override
    default public UpsertTwinRequest getUpsertTwinRequest() {
        UpsertTwinRequest.Builder reqBuilder = UpsertTwinRequest.newBuilder();
        reqBuilder.setHeaders(Builders.newHeadersBuilder((Identity)this.getAgentIdentity()));
        reqBuilder.setPayload(new AnnotationToApiBuilder().buildUpsertTwinRequestPayload(TwinID.newBuilder().setId(this.getMyIdentity().did()).build(), this));
        return reqBuilder.build();
    }
}

