package io.sheltek.ratpack.loadal

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import ratpack.groovy.handling.GroovyChainAction

import java.util.regex.Pattern

class LoadalModuleChain extends GroovyChainAction {
    Logger log = LoggerFactory.getLogger(this.class.simpleName)
    @Override
    void execute() throws Exception {
        int x = 0;
        registry.getAll(GroovyChainAction).toList().each { chainIt ->
            if (chainIt.class.equals(this.class)) {
                log.info("Not loading myself again")
                return
            }

            try {
            String bindPath = chainIt.class.simpleName.replaceAll(Pattern.compile('Chain$'), '').toLowerCase()
            prefix(bindPath) {
                all chain(chainIt)
            }
            log.info("Loading Chain ${chainIt.class.name} at /${bindPath}")
            x++;
            } catch (Exception ex) {
                log.error("Failed to load chain: ${chainIt.class.simpleName}")
            }
        }
        log.info("Loaded ${x} chains successfully of ${registry.getAll(ratpack.groovy.handling.GroovyChainAction).size()-1}")
    }
}
