package io.sheltek.ratpack.loadal

import com.google.inject.AbstractModule
import com.google.inject.Scopes
import com.google.inject.Singleton
import groovy.json.JsonOutput
import org.reflections.Reflections
import org.slf4j.Logger
import org.slf4j.LoggerFactory
import ratpack.groovy.handling.GroovyChain
import ratpack.groovy.handling.GroovyChainAction
import ratpack.guice.ConfigurableModule
import ratpack.handling.Chain

class LoadalModule extends ConfigurableModule<LoadalModuleConfig> {
//    private Config config
    private Reflections reflections
    private Logger log = LoggerFactory.getLogger(this.class.simpleName)

    @Override
    protected void configure() {
        reflections = new Reflections(LoadalModuleConfig.searchPackage);

        [GroovyChainAction, Chain, GroovyChain, ConfigurableModule, AbstractModule].each { modType ->
            reflections.getSubTypesOf(modType).each { mod ->

            }
        }
        //Initiate reflections
        log.info("Searching in: ${LoadalModuleConfig.searchPackage}")

        //Find all Chains and bind them
        log.info("Loading all chains")
        int count = 0;
        reflections.getSubTypesOf(GroovyChainAction).each { chain ->
            try {
                log.info("Loading chain ${chain.simpleName}")
                bind(chain).in(Scopes.SINGLETON)
                log.info("Chain ${chain.simpleName} Loaded")
                count++
            } catch (Exception ex) {
                log.error("Failed to load chain ${chain.simpleName}: ${ex.getMessage()}")
            }
        }
        log.info("${count} chains bound")
        //Find all modules and bind them
        bind(LoadalModuleChain).in(Scopes.SINGLETON)
    }

    public void loadAll(String searchPackage) {

    }
}
