/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.icmp4j.exception.AssertRuntimeException;
import org.icmp4j.logger.Logger;
import org.icmp4j.util.ExceptionUtil;
import org.icmp4j.util.ResourceUtil;
import org.icmp4j.util.SystemUtil;

public class JniUtil {
    private static final Logger logger = Logger.getLogger(JniUtil.class);
    private static final Set<String> librarySet = new HashSet<String>();

    public static synchronized void loadLibraryBestEffort(String libraryName) throws UnsatisfiedLinkError {
        if (librarySet.contains(libraryName)) {
            return;
        }
        boolean isLoaded = false;
        logger.info("loadLibrary trying to load " + libraryName + " from java.library.path");
        try {
            System.loadLibrary(libraryName);
            isLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("loadLibrary can't load " + libraryName + " from java.library.path exception " + e.getClass().getName() + ", errorMessage: " + ExceptionUtil.getMessage(e));
        }
        if (!isLoaded) {
            try {
                String libraryNameInJar = ResourceUtil.buildLibraryName(libraryName);
                File file = SystemUtil.extractLibraryByResource(libraryNameInJar);
                String path = file.getAbsolutePath();
                logger.info("extracted lib in : " + path);
                try {
                    System.load(path);
                    isLoaded = true;
                }
                catch (UnsatisfiedLinkError e) {
                    logger.warn("loadLibrary can't load " + libraryName + " from " + path + " exception " + e.getClass().getName() + ", errorMessage: " + ExceptionUtil.getMessage(e));
                }
            }
            catch (AssertRuntimeException e) {
                logger.warn(e.getMessage());
            }
        }
        if (!isLoaded) {
            UnsatisfiedLinkError e = new UnsatisfiedLinkError("Failed to load library " + libraryName);
            throw e;
        }
        librarySet.add(libraryName);
    }
}

