/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.logger;

import java.io.PrintStream;
import org.icmp4j.logger.LoggerAdapter;

public class PrintStreamLogger
extends LoggerAdapter {
    private static int loglevel = 2;
    private PrintStream ps;

    public static void setLogLevel(String logLevelString) {
        if (logLevelString.equalsIgnoreCase("TRACE")) {
            loglevel = 1;
        } else if (logLevelString.equalsIgnoreCase("DEBUG")) {
            loglevel = 2;
        } else if (logLevelString.equalsIgnoreCase("INFO")) {
            loglevel = 3;
        } else if (logLevelString.equalsIgnoreCase("ERROR")) {
            loglevel = 4;
        } else if (logLevelString.equalsIgnoreCase("WARN")) {
            loglevel = 5;
        } else if (logLevelString.equalsIgnoreCase("FATAL")) {
            loglevel = 6;
        }
    }

    public PrintStreamLogger() {
        this(System.out);
    }

    public PrintStreamLogger(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public boolean isDebugEnabled() {
        return 2 >= loglevel;
    }

    @Override
    public boolean isInfoEnabled() {
        return 3 >= loglevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return 1 >= loglevel;
    }

    @Override
    protected void log2(int logLevel, Object object, Throwable t) {
        if (logLevel < loglevel) {
            return;
        }
        super.log2(logLevel, object, t);
    }

    @Override
    protected void printLine(int logLevel, String line) {
        this.ps.println(line);
    }
}

