/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j;

import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.icmp4j.AsyncCallback;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.IcmpTraceRouteRequest;
import org.icmp4j.IcmpTraceRouteResponse;

public class IcmpTraceRouteUtil {
    public static IcmpTraceRouteResponse executeTraceRoute(IcmpTraceRouteRequest request) {
        int requestTtl = request.getTtl();
        int maxTtl = requestTtl > 0 ? requestTtl : 30;
        final CountDownLatch countDownLatch = new CountDownLatch(maxTtl);
        final TreeMap<Integer, IcmpPingResponse> ttlToResponseMap = new TreeMap<Integer, IcmpPingResponse>();
        for (int ttl = 1; ttl <= maxTtl; ++ttl) {
            final int finalTtl = ttl;
            AsyncCallback<IcmpPingResponse> asyncCallback = new AsyncCallback<IcmpPingResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(IcmpPingResponse response) {
                    TreeMap treeMap = ttlToResponseMap;
                    synchronized (treeMap) {
                        ttlToResponseMap.put(finalTtl, response);
                    }
                    countDownLatch.countDown();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable throwable) {
                    IcmpPingResponse response = new IcmpPingResponse();
                    response.setSuccessFlag(false);
                    response.setThrowable(throwable);
                    TreeMap treeMap = ttlToResponseMap;
                    synchronized (treeMap) {
                        ttlToResponseMap.put(finalTtl, response);
                    }
                    countDownLatch.countDown();
                }
            };
            IcmpPingRequest icmpPingRequest = IcmpPingUtil.createIcmpPingRequest();
            icmpPingRequest.setHost(request.getHost());
            icmpPingRequest.setPacketSize(request.getPacketSize());
            icmpPingRequest.setTtl(ttl);
            icmpPingRequest.setTimeout(request.getTimeout());
            IcmpPingUtil.executePingRequest(icmpPingRequest, asyncCallback);
        }
        try {
            countDownLatch.await();
            IcmpTraceRouteResponse response = new IcmpTraceRouteResponse();
            response.setTtlToResponseMap(ttlToResponseMap);
            return response;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

