/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class CallLogEntry {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    public String number;
    public int duration;
    public Date time;
    public int direction;
    public static final int INCOMING_TYPE = 1;
    public static final int OUTGOING_TYPE = 2;
    public static final int MISSED_TYPE = 3;

    public CallLogEntry(String number, int duration) {
        this(number, duration, new Date(), 1);
    }

    public CallLogEntry(String number, int duration, Date time, int direction) {
        this.number = number;
        this.duration = duration;
        this.time = time;
        this.direction = direction;
    }

    public static CallLogEntry fromJson(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            CallLogEntry entry = new CallLogEntry(json.optString("number"), json.optInt("duration"));
            entry.direction = json.optInt("direction", 1);
            entry.time = dateFormat.parse(json.optString("time"));
            return entry;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse CallLogEntry from string " + jsonString, e);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse CallLogEntry from string " + jsonString, e);
        }
    }

    public String toJSON() {
        try {
            JSONObject json = new JSONObject();
            json.put("number", (Object)this.number);
            json.put("duration", this.duration);
            json.put("direction", this.direction);
            json.put("time", (Object)dateFormat.format(this.time));
            return json.toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException("CallLogEntry cannot be converted to JSONObject", e);
        }
    }

    public String getNumber() {
        return this.number;
    }

    public int getDuration() {
        return this.duration;
    }

    public Date getDate() {
        return this.time;
    }

    public int getDirection() {
        return this.direction;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

