/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common.http;

import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class TrafficCounter {
    private static ScheduledExecutorService executorService;
    private static GlobalTrafficShapingHandler shaper;

    private static void initIfNecessary() {
        if (executorService == null || executorService.isShutdown()) {
            executorService = Executors.newScheduledThreadPool(1);
        }
        if (shaper == null) {
            shaper = new GlobalTrafficShapingHandler(executorService, 500L);
        }
    }

    public static void shutdown() {
        if (shaper != null) {
            shaper.release();
            shaper = null;
        }
        if (executorService != null) {
            executorService.shutdownNow();
            executorService = null;
        }
    }

    public static GlobalTrafficShapingHandler getShaper() {
        TrafficCounter.initIfNecessary();
        return shaper;
    }

    public static long readBytes() {
        return TrafficCounter.getShaper().trafficCounter().cumulativeReadBytes();
    }

    public static long writtenBytes() {
        return TrafficCounter.getShaper().trafficCounter().cumulativeWrittenBytes();
    }
}

