/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common.http;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import io.selendroid.server.common.http.HttpServlet;
import io.selendroid.server.common.http.impl.NettyHttpRequest;
import io.selendroid.server.common.http.impl.NettyHttpResponse;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = Logger.getLogger(ServerHandler.class.getName());
    private List<HttpServlet> httpHandlers;

    public ServerHandler(List<HttpServlet> handlers) {
        this.httpHandlers = handlers;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof FullHttpRequest)) {
            return;
        }
        FullHttpRequest request = (FullHttpRequest)msg;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().add("Connection", (Object)"close");
        NettyHttpRequest httpRequest = new NettyHttpRequest(request);
        NettyHttpResponse httpResponse = new NettyHttpResponse((FullHttpResponse)response);
        for (HttpServlet handler : this.httpHandlers) {
            handler.handleHttpRequest(httpRequest, httpResponse);
            if (!httpResponse.isClosed()) continue;
            break;
        }
        if (!httpResponse.isClosed()) {
            httpResponse.setStatus(404);
            httpResponse.end();
        }
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        super.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        ctx.fireChannelReadComplete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.log(Level.SEVERE, "Error handling request", cause);
        ctx.close();
        super.exceptionCaught(ctx, cause);
    }
}

