/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.common.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.selendroid.server.common.http.HttpServlet;
import io.selendroid.server.common.http.ServerInitializer;
import io.selendroid.server.common.http.TrafficCounter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class HttpServer {
    private int port;
    private Thread serverThread;
    private final List<HttpServlet> handlers = new ArrayList<HttpServlet>();

    public HttpServer(int port) {
        this.port = port;
    }

    public void addHandler(HttpServlet handler) {
        this.handlers.add(handler);
    }

    public void start() {
        if (this.serverThread != null) {
            throw new IllegalStateException("Server is already running");
        }
        final SynchronousQueue queue = new SynchronousQueue();
        this.serverThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                try {
                    ServerBootstrap bootstrap = new ServerBootstrap();
                    bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
                    ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ServerInitializer(HttpServer.this.handlers));
                    Channel ch = bootstrap.bind(HttpServer.this.port).sync().channel();
                    if (!(ch.localAddress() instanceof InetSocketAddress)) {
                        throw new RuntimeException("Expected an InetSocketAddress");
                    }
                    int startedPort = ((InetSocketAddress)ch.localAddress()).getPort();
                    queue.put(startedPort);
                    ch.closeFuture().sync();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    bossGroup.shutdownGracefully();
                    workerGroup.shutdownGracefully();
                    TrafficCounter.shutdown();
                }
            }
        };
        this.serverThread.start();
        try {
            Integer startedPort = (Integer)queue.poll(20L, TimeUnit.SECONDS);
            if (startedPort == null) {
                throw new RuntimeException("Exceeded timeout while waiting for webserver to start.");
            }
            this.port = startedPort;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failure while waiting for port when starting webserver.");
        }
    }

    public void stop() {
        if (this.serverThread == null) {
            throw new IllegalStateException("Server is not running");
        }
        this.serverThread.interrupt();
    }

    public int getPort() {
        return this.port;
    }
}

