/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.springsecurity.client;

import com.budjb.httprequests.HttpClient;
import com.budjb.httprequests.HttpRequest;
import com.budjb.httprequests.HttpResponse;
import com.budjb.httprequests.jersey1.JerseyHttpClientFactory;
import grails.plugin.springsecurity.client.AuthenticationRequest;
import grails.plugin.springsecurity.client.Jwt;
import grails.plugin.springsecurity.client.JwtResponse;
import grails.plugin.springsecurity.client.JwtResponseBadRequest;
import grails.plugin.springsecurity.client.JwtResponseForbidden;
import grails.plugin.springsecurity.client.JwtResponseOK;
import grails.plugin.springsecurity.client.JwtResponseUnauthorized;
import grails.plugin.springsecurity.client.RefreshRequest;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class GrailsSpringSecurityRestClient
implements GroovyObject {
    private AuthenticationRequest authenticationRequest;
    private RefreshRequest refreshRequest;
    private HttpClient client;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GrailsSpringSecurityRestClient() {
        MetaClass metaClass;
        HttpClient httpClient;
        RefreshRequest refreshRequest;
        AuthenticationRequest authenticationRequest;
        this.authenticationRequest = authenticationRequest = new AuthenticationRequest();
        this.refreshRequest = refreshRequest = new RefreshRequest();
        this.client = httpClient = new JerseyHttpClientFactory().createHttpClient();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public JwtResponse refresh(@DelegatesTo(value=RefreshRequest.class) Closure refreshRequestClosure) {
        Closure cls = (Closure)ScriptBytecodeAdapter.asType((Object)refreshRequestClosure.clone(), Closure.class);
        int n = Closure.DELEGATE_FIRST;
        cls.setResolveStrategy(n);
        RefreshRequest refreshRequest = this.refreshRequest;
        cls.setDelegate((Object)refreshRequest);
        cls.call();
        return this.executeRefresh();
    }

    public JwtResponse login(@DelegatesTo(value=AuthenticationRequest.class) Closure authenticationRequestClosure) {
        Closure cls = (Closure)ScriptBytecodeAdapter.asType((Object)authenticationRequestClosure.clone(), Closure.class);
        int n = Closure.DELEGATE_FIRST;
        cls.setResolveStrategy(n);
        AuthenticationRequest authenticationRequest = this.authenticationRequest;
        cls.setDelegate((Object)authenticationRequest);
        cls.call();
        return this.executeLogin();
    }

    private JwtResponse executeRefresh() {
        String urlStr = this.refreshRequest.endpoint();
        HttpRequest request = new HttpRequest().setUri(urlStr).setContentType("application/x-www-form-urlencoded").setQueryParameters(this.refreshRequest.queryParameters());
        HttpResponse response = this.client.post(request);
        return GrailsSpringSecurityRestClient.jwtResponseWithHttpResponse(response);
    }

    private JwtResponse executeLogin() {
        String urlStr = this.authenticationRequest.endpoint();
        HttpResponse response = null;
        if (this.authenticationRequest.getUseJsonCredentials()) {
            HttpResponse httpResponse;
            HttpRequest request = new HttpRequest().setUri(urlStr).setContentType("application/json");
            response = httpResponse = this.client.post(request, this.authenticationRequest.credentials());
        } else {
            HttpResponse httpResponse;
            HttpRequest request = new HttpRequest().setUri(urlStr).setQueryParameters(this.authenticationRequest.queryParameters());
            response = httpResponse = this.client.post(request);
        }
        return GrailsSpringSecurityRestClient.jwtResponseWithHttpResponse(response);
    }

    public static JwtResponse jwtResponseWithHttpResponse(HttpResponse response) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)response)) {
            return (JwtResponse)ScriptBytecodeAdapter.castToType(null, JwtResponse.class);
        }
        if (response.getStatus() == 200) {
            Map json = (Map)ScriptBytecodeAdapter.castToType((Object)response.getEntity(Map.class), Map.class);
            return GrailsSpringSecurityRestClient.jwtResponseOKWithMap(json);
        }
        if (response.getStatus() == 401) {
            return new JwtResponseUnauthorized();
        }
        if (response.getStatus() == 403) {
            return new JwtResponseForbidden();
        }
        if (response.getStatus() == 400) {
            return new JwtResponseBadRequest();
        }
        return (JwtResponse)ScriptBytecodeAdapter.castToType(null, JwtResponse.class);
    }

    public static JwtResponseOK jwtResponseOKWithMap(Map json) {
        CallSite[] callSiteArray = GrailsSpringSecurityRestClient.$getCallSiteArray();
        return (JwtResponseOK)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(JwtResponseOK.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jwt", callSiteArray[1].callConstructor(Jwt.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"username", callSiteArray[2].callGetProperty((Object)json), "roles", callSiteArray[3].callGetProperty((Object)json), "tokenType", callSiteArray[4].callGetProperty((Object)json), "accessToken", callSiteArray[5].callGetProperty((Object)json), "refreshToken", callSiteArray[6].callGetProperty((Object)json), "expiresIn", callSiteArray[7].callGetProperty((Object)json)}))})), JwtResponseOK.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GrailsSpringSecurityRestClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public AuthenticationRequest getAuthenticationRequest() {
        return this.authenticationRequest;
    }

    public void setAuthenticationRequest(AuthenticationRequest authenticationRequest) {
        this.authenticationRequest = authenticationRequest;
    }

    public RefreshRequest getRefreshRequest() {
        return this.refreshRequest;
    }

    public void setRefreshRequest(RefreshRequest refreshRequest) {
        this.refreshRequest = refreshRequest;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient httpClient) {
        this.client = httpClient;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "username";
        stringArray[3] = "roles";
        stringArray[4] = "token_type";
        stringArray[5] = "access_token";
        stringArray[6] = "refresh_token";
        stringArray[7] = "expires_in";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[8];
        GrailsSpringSecurityRestClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GrailsSpringSecurityRestClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GrailsSpringSecurityRestClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

