/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import science.raketen.voodoo.Voodoo;

public abstract class ContextualType<T> {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private static final Class[] EMPTY_TYPE_ARRAY = new Class[0];
    private final Class<T> type;

    public ContextualType(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    protected T createInstance(Class<T> type) {
        try {
            T targetInstance = this.construct(type);
            this.processFields(type, targetInstance);
            this.processPostConstruct(type, targetInstance);
            return targetInstance;
        }
        catch (Exception ex) {
            Logger.getLogger(ContextualType.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private T construct(Class<T> type) throws Exception {
        List injectableConstructors = Arrays.stream(type.getConstructors()).filter(constructor -> constructor.getAnnotation(Inject.class) != null).collect(Collectors.toList());
        Constructor constructor2 = null;
        Object[] params = EMPTY_OBJ_ARRAY;
        switch (injectableConstructors.size()) {
            case 0: {
                constructor2 = type.getConstructor(EMPTY_TYPE_ARRAY);
                break;
            }
            case 1: {
                constructor2 = (Constructor)injectableConstructors.get(0);
                Class<?>[] parameterTypes = constructor2.getParameterTypes();
                params = Arrays.stream(parameterTypes).map(paramType -> Voodoo.current().instance(paramType)).toArray();
                break;
            }
            default: {
                throw new RuntimeException("Ambigious Injectable constructor for " + type);
            }
        }
        return constructor2.newInstance(params);
    }

    private <T> void processFields(Class<T> type, T targetInstance) {
        for (Field field : type.getDeclaredFields()) {
            Inject annotation = field.getAnnotation(Inject.class);
            if (annotation == null) continue;
            Object instance = Voodoo.current().instance(field.getType());
            field.setAccessible(true);
            try {
                field.set(targetInstance, instance);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private <T> void processPostConstruct(Class type, T instance) {
        Method[] declaredMethods = type.getDeclaredMethods();
        Arrays.stream(declaredMethods).filter(method -> method.getAnnotation(PostConstruct.class) != null).forEach(postConstructMethod -> {
            try {
                postConstructMethod.setAccessible(true);
                postConstructMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        });
    }

    public abstract T getContextualInstance();
}

