/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo.context;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import science.raketen.voodoo.Voodoo;
import science.raketen.voodoo.context.Context;
import science.raketen.voodoo.context.ContextualType;

public class ContextManager {
    private ContextManager() {
    }

    public static Map<Class, ContextualType> process(String packageName) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forManifest()));
        Set contexts = reflections.getSubTypesOf(Context.class);
        Stream<ContextualType> contextualTypes = contexts.parallelStream().map(contextType -> ContextManager.constructContext(contextType)).map(context -> ContextManager.initalizeContext(context, reflections)).flatMap(ctypes -> ctypes.stream());
        return ContextManager.mapTypes(contextualTypes);
    }

    private static Set<ContextualType> initalizeContext(Context context, Reflections reflections) {
        Set annotatedTypes = reflections.getTypesAnnotatedWith(context.getContextAnnotation());
        return context.initalizeContext(annotatedTypes);
    }

    private static Map<Class, ContextualType> mapTypes(Stream<ContextualType> contextualTypes) {
        ConcurrentHashMap<Class, ContextualType> types = new ConcurrentHashMap<Class, ContextualType>();
        contextualTypes.forEach(contextualType -> {
            types.put(contextualType.getType(), (ContextualType)contextualType);
            ContextManager.registerInterfaces(contextualType, types);
            ContextManager.registerSuperTypes(contextualType, types);
        });
        return types;
    }

    private static void registerSuperTypes(ContextualType contextualType, Map<Class, ContextualType> types) {
        Class type = contextualType.getType();
        Class superclass = type.getSuperclass();
        while (superclass != null && superclass != Object.class) {
            if (types.containsKey(superclass)) {
                throw new RuntimeException("Ambigious Puppet for " + superclass);
            }
            types.put(superclass, contextualType);
            superclass = type.getSuperclass() == superclass ? null : type.getSuperclass();
        }
    }

    private static void registerInterfaces(ContextualType context, Map<Class, ContextualType> types) {
        Class type = context.getType();
        for (Class<?> interFace : type.getInterfaces()) {
            if (types.containsKey(interFace)) {
                throw new RuntimeException("Ambigious Puppet for " + interFace);
            }
            types.put(interFace, context);
        }
    }

    private static Context constructContext(Class<? extends Context> contextType) throws RuntimeException {
        try {
            return contextType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

