/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo.context;

import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import science.raketen.voodoo.Voodoo;
import science.raketen.voodoo.context.Context;
import science.raketen.voodoo.context.ContextualType;

public class ContextScanner {
    private ContextScanner() {
    }

    public static Map<Class, ContextualType> processContexts(String packageName) {
        Reflections contextScan = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forManifest()));
        Set contexts = contextScan.getSubTypesOf(Context.class);
        Reflections typeScan = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().exclude("com.google.*").include(packageName)).setUrls(ClasspathHelper.forManifest()));
        ConcurrentHashMap<Class, ContextualType> types = new ConcurrentHashMap<Class, ContextualType>();
        contexts.parallelStream().map(contextType -> ContextScanner.constructContext(contextType)).map(context -> context.initalizeContext(typeScan.getTypesAnnotatedWith(context.getContextualAnnotation()))).flatMap(list -> ((Set)list).stream()).forEach(ct -> {
            ContextualType contextualType = (ContextualType)ct;
            types.put(contextualType.getType(), contextualType);
            ContextScanner.registerInterfaces(contextualType, types);
            ContextScanner.registerSuperTypes(contextualType, types);
        });
        return types;
    }

    private static void registerSuperTypes(ContextualType contextualType, Map<Class, ContextualType> types) {
        Class type = contextualType.getType();
        Class superclass = type.getSuperclass();
        while (superclass != null && superclass != Object.class) {
            if (types.containsKey(superclass)) {
                throw new RuntimeException("Ambigious Puppet for " + superclass);
            }
            types.put(superclass, contextualType);
            superclass = type.getSuperclass() == superclass ? null : type.getSuperclass();
        }
    }

    private static void registerInterfaces(ContextualType context, Map<Class, ContextualType> types) {
        Class type = context.getType();
        for (Class<?> interFace : type.getInterfaces()) {
            if (types.containsKey(interFace)) {
                throw new RuntimeException("Ambigious Puppet for " + interFace);
            }
            types.put(interFace, context);
        }
    }

    private static Context constructContext(Class<? extends Context> contextType) throws RuntimeException {
        try {
            return contextType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

