/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo.context.singleton;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import science.raketen.voodoo.context.ContextualType;

public class SingletonContextualType<T>
extends ContextualType {
    private final T singleton;

    public SingletonContextualType(Class type) {
        super(type);
        this.singleton = this.createSingleton(type);
    }

    private T createSingleton(Class type) {
        try {
            Constructor constructor = type.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(SingletonContextualType.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public T getContextualInstance() {
        return this.singleton;
    }
}

