/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo.context.singleton;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.reflections.Reflections;
import science.raketen.voodoo.context.Context;
import science.raketen.voodoo.context.ContextualType;
import science.raketen.voodoo.context.singleton.SingletonContextualType;

public class SingletonContext
implements Context {
    private static final Class SCOPE_ANNOTATION = Singleton.class;

    @Override
    public Class getContextualAnnotation() {
        return SCOPE_ANNOTATION;
    }

    @Override
    public List<? extends ContextualType> initalizeContext(Reflections reflections) {
        Set puppetTypes = reflections.getTypesAnnotatedWith(SCOPE_ANNOTATION);
        return puppetTypes.stream().filter(type -> !type.isInterface() && !Modifier.isAbstract(type.getModifiers())).map(type -> new SingletonContextualType((Class)type)).collect(Collectors.toList());
    }
}

