/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo.context;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import science.raketen.voodoo.Voodoo;
import science.raketen.voodoo.context.Context;
import science.raketen.voodoo.context.ContextualType;

public class ContextScanner {
    private ContextScanner() {
    }

    public static Map<Class, ContextualType> processContexts(String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set contexts = reflections.getSubTypesOf(Context.class);
        ConcurrentHashMap<Class, ContextualType> types = new ConcurrentHashMap<Class, ContextualType>();
        contexts.parallelStream().map(contextType -> ContextScanner.constructContext(contextType)).map(context -> context.initalizeContext(reflections)).flatMap(Collection::stream).forEach(contextualType -> {
            types.put(contextualType.getType(), (ContextualType)contextualType);
            ContextScanner.registerInterfaces(contextualType, types);
            ContextScanner.registerSuperTypes(contextualType, types);
        });
        return types;
    }

    private static void registerSuperTypes(ContextualType contextualType, Map<Class, ContextualType> types) {
        Class type = contextualType.getType();
        Class superclass = type.getSuperclass();
        while (superclass != null && superclass != Object.class) {
            if (types.containsKey(superclass)) {
                throw new RuntimeException("Ambigious Puppet for " + superclass);
            }
            types.put(superclass, contextualType);
            superclass = type.getSuperclass() == superclass ? null : type.getSuperclass();
        }
    }

    private static void registerInterfaces(ContextualType context, Map<Class, ContextualType> types) {
        Class type = context.getType();
        for (Class<?> interFace : type.getInterfaces()) {
            if (types.containsKey(interFace)) {
                throw new RuntimeException("Ambigious Puppet for " + interFace);
            }
            types.put(interFace, context);
        }
    }

    private static Context constructContext(Class<? extends Context> contextType) throws RuntimeException {
        try {
            return contextType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

