/*
 * Decompiled with CFR 0.152.
 */
package science.raketen.voodoo;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import science.raketen.voodoo.context.ContextScanner;
import science.raketen.voodoo.context.ContextualType;

public class Voodoo {
    private final Map<Class, ContextualType> types;

    private Voodoo(String packageName) {
        this.types = ContextScanner.processContexts(packageName);
    }

    public static Voodoo initalize() {
        return Voodoo.initalize("");
    }

    public static Voodoo initalize(String packageName) {
        return new Voodoo(packageName);
    }

    public <T> T instance(Class<T> type) {
        T contextualInstance = null;
        try {
            contextualInstance = this.types.get(type).getContextualInstance();
            this.processFields(type, contextualInstance);
        }
        catch (Exception ex) {
            Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return contextualInstance;
    }

    private <T> void processFields(Class<T> type, T targetInstance) {
        for (Field field : type.getDeclaredFields()) {
            Inject annotation = field.getAnnotation(Inject.class);
            if (annotation == null) continue;
            Object instance = this.instance(field.getType());
            field.setAccessible(true);
            try {
                field.set(targetInstance, instance);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Voodoo.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

