/*
 * Copyright (c) 2021 the original author or authors.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package science.aist.machinelearning.problem.mapping;

import science.aist.machinelearning.problem.DoubleElement;

import java.io.Serializable;
import java.util.function.ToDoubleFunction;

/**
 * Maps a DoubleElement to double
 *
 * @author Andreas Pointner
 * @since 1.0
 */
public class DoubleElementToDoubleMapper implements ToDoubleFunction<DoubleElement>, Serializable {
    @Override
    public double applyAsDouble(DoubleElement doubleElement) {
        return doubleElement.getValue();
    }
}
