/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.problem.genome.fitness;

import java.util.Objects;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.problem.genome.Element;

public class ElementEqualityCachet
implements CachetEvaluator<Element[], Element[]> {
    private String targetSequence;

    public String getTargetSequence() {
        return this.targetSequence;
    }

    public void setTargetSequence(String targetSequence) {
        this.targetSequence = targetSequence;
    }

    public double evaluateQuality(Solution<Element[], Element[]> solution) {
        double quality = 0.0;
        if (solution != null && solution.getSolutionGenes() != null && solution.getSolutionGenes().size() > 0) {
            SolutionGene genes = (SolutionGene)solution.getSolutionGenes().get(0);
            for (int i = 0; i < this.targetSequence.length(); ++i) {
                if (this.targetSequence.charAt(i) == ((Element[])genes.getGene())[i].getValue()) continue;
                quality += 1.0;
            }
            solution.getCachets().add(new Cachet(quality, "ElementEqualityCachet"));
        }
        return quality;
    }

    public String getName() {
        return "ElementEqualityCachet";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementEqualityCachet that = (ElementEqualityCachet)o;
        return Objects.equals(this.targetSequence, that.targetSequence);
    }

    public int hashCode() {
        return this.targetSequence != null ? this.targetSequence.hashCode() : 0;
    }
}

