/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.mapping;

import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.ProblemGene;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.mapping.GeneCreator;
import science.aist.machinelearning.core.mapping.SolutionCreator;
import science.aist.machinelearning.core.options.Descriptor;

public class OneToOneSolutionCreator<ST, PT>
implements SolutionCreator<ST, PT>,
Configurable {
    public static int runs = 0;
    private GeneCreator<ST, PT> geneCreator;

    @Override
    public Solution<ST, PT> createSolution(Problem<PT> problem) {
        ++runs;
        Solution solution = new Solution();
        if (problem != null && problem.getProblemGenes() != null) {
            for (ProblemGene<PT> problemGene : problem.getProblemGenes()) {
                SolutionGene<ST, PT> solutionGene = new SolutionGene<ST, PT>(this.geneCreator.createGene(problemGene));
                solutionGene.addProblemGene(problemGene);
                solution.addGene(solutionGene);
            }
        }
        return solution;
    }

    @Override
    public void setGeneCreator(GeneCreator<ST, PT> geneCreator) {
        this.geneCreator = geneCreator;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("geneCreator", new Descriptor<GeneCreator<ST, PT>>(this.geneCreator));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("geneCreator")) {
                this.setGeneCreator((GeneCreator)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

