/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.ProblemGene;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.mapping.GeneCreator;
import science.aist.machinelearning.core.mapping.SolutionCreator;
import science.aist.machinelearning.core.options.Descriptor;

public class NToOneSolutionCreator<ST, PT>
implements SolutionCreator<ST, PT>,
Configurable {
    private final Random r = new Random();
    private GeneCreator<ST, PT> geneCreator;
    private int minGenes = 1;
    private int maxGenes = 10;

    @Override
    public Solution<ST, PT> createSolution(Problem<PT> problem) {
        Solution solution = new Solution();
        if (problem != null && problem.getProblemGenes() != null) {
            for (int i = this.r.nextInt(this.maxGenes - this.minGenes) + this.minGenes; i >= 0; --i) {
                ProblemGene<PT> problemGene = problem.getProblemGenes().get(this.r.nextInt(problem.getProblemGenes().size()));
                SolutionGene<ST, PT> solutionGene = new SolutionGene<ST, PT>(this.geneCreator.createGene(problemGene));
                solutionGene.addProblemGene(problemGene);
                solution.addGene(solutionGene);
            }
        }
        return solution;
    }

    @Override
    public void setGeneCreator(GeneCreator<ST, PT> geneCreator) {
        this.geneCreator = geneCreator;
    }

    public int getMinGenes() {
        return this.minGenes;
    }

    public void setMinGenes(int minGenes) {
        this.minGenes = minGenes;
    }

    public int getMaxGenes() {
        return this.maxGenes;
    }

    public void setMaxGenes(int maxGenes) {
        this.maxGenes = maxGenes;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("geneCreator", new Descriptor<GeneCreator<ST, PT>>(this.geneCreator));
        options.put("minGenes", new Descriptor<Integer>(this.minGenes));
        options.put("maxGenes", new Descriptor<Integer>(this.maxGenes));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            switch (name) {
                case "geneCreator": {
                    this.setGeneCreator((GeneCreator)descriptor.getValue());
                    break;
                }
                case "minGenes": {
                    this.setMinGenes((Integer)descriptor.getValue());
                    break;
                }
                case "maxGenes": {
                    this.setMaxGenes((Integer)descriptor.getValue());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

