/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.fitness;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.fitness.CachetEvaluator;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.options.Descriptor;

public class GenericEvaluatorImpl<ST, PT>
implements Evaluator<ST, PT>,
Configurable {
    private static final Logger logger = Logger.getLogger(GenericEvaluatorImpl.class);
    private Map<CachetEvaluator<ST, PT>, Double> cachetEvaluators;

    @Override
    public double evaluateQuality(Solution solution) {
        logger.trace((Object)"Evaluating quality");
        double quality = 0.0;
        if (solution == null) {
            return Double.MAX_VALUE;
        }
        if (solution.getCachets() != null) {
            solution.getCachets().clear();
        }
        for (Map.Entry<CachetEvaluator<ST, PT>, Double> evaluator : this.cachetEvaluators.entrySet()) {
            quality += evaluator.getKey().evaluateQuality(solution) * evaluator.getValue();
        }
        solution.setQuality(quality);
        logger.trace((Object)"Finished evaluating quality");
        return quality;
    }

    @Override
    public Map<CachetEvaluator<ST, PT>, Double> returnCachetDictionary() {
        return this.cachetEvaluators;
    }

    @Override
    public String evaluationIdentity() {
        return this.cachetEvaluators.keySet().stream().map(i -> i.getName() + " * " + this.cachetEvaluators.get(i)).collect(Collectors.joining(" + "));
    }

    @Required
    public void setCachetEvaluators(Map<CachetEvaluator<ST, PT>, Double> cachetEvaluators) {
        this.cachetEvaluators = cachetEvaluators;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("cachetEvaluators", new Descriptor<Map<CachetEvaluator<ST, PT>, Double>>(this.cachetEvaluators));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("cachetEvaluators")) {
                this.setCachetEvaluators((Map)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

