/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.Collection;
import java.util.LinkedList;
import science.aist.machinelearning.core.experiment.AbstractChoice;
import science.aist.machinelearning.core.experiment.Choice;
import science.aist.machinelearning.core.experiment.ExperimentIdentifier;
import science.aist.machinelearning.core.options.Descriptor;

public class WrappingChoice<O>
extends AbstractChoice<O> {
    private Choice<O> choice;

    public WrappingChoice(Choice choice) {
        super(choice.getName());
        this.choice = choice;
    }

    @Override
    public ExperimentIdentifier getCurrentIdentifier() {
        return this.choice.getCurrentIdentifier();
    }

    @Override
    public O next() {
        Object value = this.choice.next();
        return (O)(value == null ? null : new Descriptor(value));
    }

    @Override
    public O current() {
        O value = this.choice.current();
        return (O)(value == null ? null : new Descriptor<O>(value));
    }

    @Override
    public boolean hasNext() {
        return this.choice.hasNext();
    }

    @Override
    public void reset() {
        this.choice.reset();
    }

    public void setChoice(Choice<O> choice) {
        if (choice == null) {
            throw new IllegalArgumentException("choice must never be null");
        }
        choice.setParent(this);
        this.choice = choice;
    }

    @Override
    public Collection<Choice> getChildren() {
        LinkedList<Choice> choices = new LinkedList<Choice>();
        choices.add(this.choice);
        return choices;
    }

    @Override
    protected void replaceChild(Choice<O> oldChoice, Choice<O> newChoice) {
        oldChoice.setParent(null);
        this.choice = newChoice;
    }

    @Override
    public Choice findConfig(String name) {
        return this.choice.findConfig(name);
    }
}

