/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import science.aist.machinelearning.core.experiment.AbstractChoice;
import science.aist.machinelearning.core.experiment.Choice;
import science.aist.machinelearning.core.experiment.ExperimentIdentifier;

public class SingleUnwrappingChoice<O>
extends AbstractChoice<O> {
    private List<Choice<O>> choices = new ArrayList<Choice<O>>();
    private int current = -1;

    public SingleUnwrappingChoice(String name) {
        super(name);
    }

    @Override
    public ExperimentIdentifier getCurrentIdentifier() {
        Map<String, Object> identifier = this.choices.get(this.current).getCurrentIdentifier().getIdentifier();
        identifier.put(this.getName(), this.choices.get(this.current).getName());
        return new ExperimentIdentifier(identifier);
    }

    @Override
    public O next() {
        if (this.choices == null || this.current >= this.choices.size()) {
            return null;
        }
        if (this.current < 0 || !this.choices.get(this.current).hasNext() && this.current + 1 < this.choices.size()) {
            ++this.current;
        }
        return this.choices.get(this.current).hasNext() ? (O)this.choices.get(this.current).next() : null;
    }

    @Override
    public O current() {
        return this.choices == null || this.choices.size() < this.current || this.current < 0 ? null : (O)this.choices.get(this.current).current();
    }

    @Override
    public boolean hasNext() {
        return this.choices != null && (this.choices.size() > this.current + 1 || this.choices.size() > this.current && this.choices.get(this.current).hasNext());
    }

    @Override
    public void reset() {
        this.current = -1;
    }

    public void setChoices(List<Choice<O>> choices) {
        choices.forEach(x -> x.setParent(this));
        this.choices = choices;
    }

    public void addChoice(Choice<O> choice) {
        choice.setParent(this);
        this.choices.add(choice);
    }

    @Override
    public Collection<Choice> getChildren() {
        return new LinkedList<Choice>(this.choices);
    }

    @Override
    protected void replaceChild(Choice<O> oldChoice, Choice<O> newChoice) {
        oldChoice.setParent(null);
        this.choices.remove(oldChoice);
        this.addChoice(newChoice);
    }
}

