/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import science.aist.machinelearning.core.experiment.AbstractChoice;

public class SingleChoiceConfig<O>
extends AbstractChoice<O> {
    protected List<O> choices = new ArrayList<O>();
    private int current = -1;

    public SingleChoiceConfig(String name) {
        super(name);
    }

    @Override
    public O next() {
        return this.choices.size() < this.current ? null : (O)this.choices.get(++this.current);
    }

    @Override
    public O current() {
        return this.choices.size() < this.current || this.current < 0 ? null : (O)this.choices.get(this.current);
    }

    @Override
    public boolean hasNext() {
        return this.choices != null && this.choices.size() > this.current + 1;
    }

    @Override
    public void reset() {
        this.current = -1;
    }

    public void setChoices(List<O> choices) {
        this.choices = Objects.requireNonNullElseGet(choices, ArrayList::new);
    }

    public void addChoice(O choice) {
        this.choices.add(choice);
    }
}

