/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import science.aist.machinelearning.core.experiment.AbstractChoice;
import science.aist.machinelearning.core.experiment.Choice;
import science.aist.machinelearning.core.experiment.FixedChoice;

public abstract class IteratingChoice<O, SUBOPT>
extends AbstractChoice<O> {
    private final List<Choice> previousIterations = new LinkedList<Choice>();
    protected Class<?> optionClass;
    protected O choice;
    protected List<Choice<? extends SUBOPT>> configurationOptions = new LinkedList<Choice<? extends SUBOPT>>();
    protected List<Choice<? extends SUBOPT>> fixedOptions = new LinkedList<Choice<? extends SUBOPT>>();
    private Iterator<Choice<? extends SUBOPT>> iterator;
    private Choice currentIteration;

    public IteratingChoice(String name, Class<?> optionClass) {
        super(name);
        this.optionClass = optionClass;
        this.reset();
    }

    protected abstract void rebuildObject();

    @Override
    public O next() {
        if (this.currentIteration == null) {
            new LinkedList<Choice<SUBOPT>>(this.configurationOptions).forEach(x -> {
                x.next();
                if (!x.hasNext()) {
                    this.configurationOptions.remove(x);
                    this.fixedOptions.add((Choice<SUBOPT>)x);
                }
            });
            this.reset();
            if (this.iterator.hasNext()) {
                this.currentIteration = this.iterator.next();
            }
        } else if (this.previousIterations.stream().anyMatch(Iterator::hasNext)) {
            for (Choice previousIteration : this.previousIterations) {
                if (!previousIteration.hasNext()) {
                    previousIteration.reset();
                    continue;
                }
                previousIteration.next();
                break;
            }
        } else if (this.currentIteration.hasNext()) {
            this.previousIterations.forEach(Choice::reset);
            this.currentIteration.next();
        } else {
            this.previousIterations.add(this.currentIteration);
            this.currentIteration = this.iterator.next();
            this.previousIterations.forEach(Choice::reset);
            this.currentIteration.next();
        }
        this.rebuildObject();
        return this.choice;
    }

    @Override
    public O current() {
        return this.choice;
    }

    @Override
    public boolean hasNext() {
        return this.choice == null || this.iterator.hasNext() || this.currentIteration != null && this.currentIteration.hasNext() || this.previousIterations.stream().anyMatch(Iterator::hasNext);
    }

    @Override
    public void reset() {
        this.fixedOptions.forEach(Choice::reset);
        this.configurationOptions.forEach(Choice::reset);
        this.iterator = this.configurationOptions.iterator();
        this.currentIteration = null;
        this.previousIterations.clear();
    }

    public void setConfigurationOptions(List<Choice> options) {
        if (options == null) {
            return;
        }
        options.forEach(value -> {
            if (value instanceof FixedChoice) {
                value.setParent(this);
                this.fixedOptions.add((Choice<SUBOPT>)value);
            } else {
                this.configurationOptions.add((Choice<SUBOPT>)value);
            }
        });
        this.reset();
    }

    public void addConfigurationOption(Choice option) {
        if (option == null) {
            return;
        }
        option.setParent(this);
        if (option instanceof FixedChoice) {
            this.fixedOptions.add(option);
        } else {
            this.configurationOptions.add(option);
        }
        this.reset();
    }

    @Override
    public Collection<Choice> getChildren() {
        LinkedList<Choice> list = new LinkedList<Choice>(this.fixedOptions);
        list.addAll(this.configurationOptions);
        return list;
    }

    @Override
    protected void replaceChild(Choice<O> oldChoice, Choice<O> newChoice) {
        oldChoice.setParent(null);
        this.configurationOptions.remove(oldChoice);
        this.fixedOptions.remove(oldChoice);
        this.addConfigurationOption(newChoice);
    }
}

