/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.LinkedList;
import java.util.List;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import science.aist.machinelearning.core.experiment.Experiment;
import science.aist.machinelearning.core.experiment.ExperimentIdentifier;
import science.aist.machinelearning.core.experiment.ExperimentResult;

@NodeEntity
public class ExperimentGroup<ST, PT> {
    @Id
    private Long id;
    private List<Experiment<ST, PT>> experiments = new LinkedList<Experiment<ST, PT>>();

    public ExperimentGroup() {
    }

    public ExperimentGroup(List<Experiment<ST, PT>> experiments) {
        this.experiments = experiments;
    }

    public ExperimentResult<ST, PT> conductExperiment() {
        ExperimentResult result = new ExperimentResult();
        this.experiments.forEach(x -> x.conductExperiment().getResults().forEach((key, value) -> {
            if (result.getResults().containsKey(key)) {
                result.getResults().get(key).addAll(value);
            } else {
                result.getResults().put((ExperimentIdentifier)key, value);
            }
        }));
        return result;
    }

    public void setExperiments(List<Experiment<ST, PT>> experiments) {
        this.experiments = experiments;
    }

    public void addExperiment(Experiment<ST, PT> experiment) {
        this.experiments.add(experiment);
    }
}

