/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import science.aist.machinelearning.core.Algorithm;
import science.aist.machinelearning.core.Configurable;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.ProblemGene;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.experiment.Choice;
import science.aist.machinelearning.core.experiment.ConfigurableChoice;
import science.aist.machinelearning.core.experiment.ExperimentIdentifier;
import science.aist.machinelearning.core.experiment.ExperimentResult;
import science.aist.machinelearning.core.experiment.FixedChoice;
import science.aist.machinelearning.core.experiment.ProblemChoice;
import science.aist.machinelearning.core.experiment.SingleChoiceConfig;
import science.aist.machinelearning.core.experiment.SingleUnwrappingChoice;
import science.aist.machinelearning.core.experiment.WrappingChoice;
import science.aist.machinelearning.core.options.Descriptor;

@NodeEntity
public class Experiment<ST, PT> {
    @Id
    private Long id;
    private int repeats = 5;
    private SingleUnwrappingChoice<Problem<PT>> problems = new SingleUnwrappingChoice("problems");
    private SingleUnwrappingChoice<Algorithm<ST, PT>> algorithms = new SingleUnwrappingChoice("algorithms");

    public Experiment() {
    }

    public Experiment(SingleUnwrappingChoice<Problem<PT>> problems, SingleUnwrappingChoice<Algorithm<ST, PT>> algorithms) {
        this.problems = problems;
        this.algorithms = algorithms;
    }

    public Experiment(int repeats, SingleUnwrappingChoice<Problem<PT>> problems, SingleUnwrappingChoice<Algorithm<ST, PT>> algorithms) {
        this(problems, algorithms);
        this.repeats = repeats;
    }

    public static <O> Choice<Problem<O>> createProblemChoices(String name, O problem) {
        return Experiment.createProblemChoices(name, problem, false, false);
    }

    public static <O> Choice<Problem<O>> createProblemChoices(String name, O problem, boolean prepareChoices, boolean makeValuesExchangeable) {
        ArrayList<O> list = new ArrayList<O>();
        list.add(problem);
        return Experiment.createProblemChoices(name, list, prepareChoices, makeValuesExchangeable);
    }

    public static <O> Choice<Problem<O>> createProblemChoices(String name, List<O> problem) {
        return Experiment.createProblemChoices(name, problem, false, false);
    }

    public static <O> Choice<Problem<O>> createProblemChoices(String name, List<O> problem, boolean prepareChoices, boolean makeValuesExchangeable) {
        if (problem == null || problem.isEmpty()) {
            return null;
        }
        if (!(problem.get(0) instanceof Configurable)) {
            ArrayList problemGenes = new ArrayList();
            problem.forEach(x -> problemGenes.add(new ProblemGene<Object>(x)));
            Problem prob = new Problem(problemGenes);
            return new FixedChoice<Problem<O>>(name, prob);
        }
        ProblemChoice problemChoice = new ProblemChoice(name, problem.get(0).getClass());
        int i = 0;
        for (O gene : problem) {
            problemChoice.addConfigurationOption(Experiment.createConfigurationChoices("[" + i++ + "]", (Configurable)gene, prepareChoices, makeValuesExchangeable));
        }
        return problemChoice;
    }

    public static <O extends Configurable> ConfigurableChoice<O> createConfigurationChoices(String name, O c) {
        return Experiment.createConfigurationChoices(name, c, false, false);
    }

    public static <O extends Configurable> ConfigurableChoice<O> createConfigurationChoices(String name, O c, boolean prepareChoices, boolean makeValuesExchangeable) {
        ConfigurableChoice result = new ConfigurableChoice(name, (Class<? extends Configurable>)((Class<Configurable>)c.getClass()));
        c.getOptions().forEach((key, value) -> {
            Choice<Descriptor<Object>> subChoice;
            if (value.getValue() instanceof Configurable) {
                ConfigurableChoice<Configurable> subConfigurableChoice = Experiment.createConfigurationChoices(key, (Configurable)value.getValue(), prepareChoices, makeValuesExchangeable);
                subChoice = makeValuesExchangeable ? new WrappingChoice(subConfigurableChoice) : new FixedChoice<Descriptor>((String)key, (Descriptor)value);
            } else if (prepareChoices && value.getValue() != null && value.getClass().equals(Descriptor.class)) {
                switch (value.getValue().getClass().getName()) {
                    case "java.lang.Integer": {
                        subChoice = Experiment.createRangeChoice(key, new Object[]{1, 3, 5});
                        break;
                    }
                    case "java.lang.Double": {
                        subChoice = Experiment.createRangeChoice(key, new Object[]{0.1, 0.3, 0.5});
                        break;
                    }
                    case "java.lang.Long": {
                        subChoice = Experiment.createRangeChoice(key, new Object[]{1L, 3L, 5L});
                        break;
                    }
                    default: {
                        if (makeValuesExchangeable) {
                            subChoice = new SingleChoiceConfig((String)key);
                            subChoice.addChoice((Descriptor<Object>)value);
                            break;
                        }
                        subChoice = new FixedChoice<Descriptor>((String)key, (Descriptor)value);
                        break;
                    }
                }
            } else if (makeValuesExchangeable) {
                subChoice = new SingleChoiceConfig<Descriptor>((String)key);
                subChoice.addChoice((Descriptor<Object>)value);
            } else {
                subChoice = new FixedChoice<Descriptor>((String)key, (Descriptor)value);
            }
            result.addConfigurationOption(subChoice);
        });
        return result;
    }

    private static Choice<Descriptor> createRangeChoice(String name, Object[] values) {
        SingleChoiceConfig<Descriptor> choice = new SingleChoiceConfig<Descriptor>(name);
        for (Object value : values) {
            choice.addChoice(new Descriptor<Object>(value));
        }
        return choice;
    }

    public ExperimentResult<ST, PT> conductExperiment() {
        ExperimentResult<ST, PT> result = new ExperimentResult<ST, PT>();
        while (this.problems.hasNext()) {
            this.problems.next();
            ExperimentIdentifier problemIdentifier = this.problems.getCurrentIdentifier();
            Problem<PT> problem = this.problems.current();
            this.algorithms.reset();
            while (this.algorithms.hasNext()) {
                this.algorithms.next();
                ExperimentIdentifier algorithmIdentifier = this.algorithms.getCurrentIdentifier();
                HashMap<String, Object> identifiers = new HashMap<String, Object>(problemIdentifier.getIdentifier());
                identifiers.putAll(algorithmIdentifier.getIdentifier());
                ExperimentIdentifier identifier = new ExperimentIdentifier(identifiers);
                for (int i = 0; i < this.repeats; ++i) {
                    Algorithm<ST, PT> algorithm = this.algorithms.current();
                    Solution<ST, PT> solution = algorithm.solve(problem);
                    result.add(identifier, solution);
                }
            }
        }
        return result;
    }

    public void addProblem(Choice<Problem<PT>> problem) {
        this.problems.addChoice(problem);
    }

    public void addAlgorithm(ConfigurableChoice<Algorithm<ST, PT>> algorithm) {
        this.algorithms.addChoice(algorithm);
    }

    public Long getId() {
        return this.id;
    }

    public int getRepeats() {
        return this.repeats;
    }

    public void setRepeats(int repeats) {
        this.repeats = repeats;
    }

    public SingleUnwrappingChoice<Problem<PT>> getProblems() {
        return this.problems;
    }

    public void setProblems(SingleUnwrappingChoice<Problem<PT>> problems) {
        this.problems = problems;
    }

    public SingleUnwrappingChoice<Algorithm<ST, PT>> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(SingleUnwrappingChoice<Algorithm<ST, PT>> algorithms) {
        this.algorithms = algorithms;
    }
}

