/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core.experiment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import science.aist.machinelearning.core.experiment.Choice;
import science.aist.machinelearning.core.experiment.ExperimentIdentifier;
import science.aist.machinelearning.core.options.Descriptor;

public abstract class AbstractChoice<O>
implements Choice<O> {
    private final String name;
    protected AbstractChoice parent;

    public AbstractChoice(String name) {
        this.name = name;
    }

    @Override
    public ExperimentIdentifier getCurrentIdentifier() {
        HashMap<String, Object> identifierMap = new HashMap<String, Object>();
        if (this.getChildren() != null) {
            this.getChildren().stream().map(Choice::getCurrentIdentifier).forEach(x -> x.getIdentifier().forEach((key, value) -> identifierMap.put(this.getName() + "." + key, value)));
        } else if (this.current() instanceof Descriptor) {
            identifierMap.put(this.name, ((Descriptor)this.current()).getValue());
        } else {
            identifierMap.put(this.name, this.current());
        }
        return new ExperimentIdentifier(identifierMap);
    }

    @Override
    public Choice findConfig(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        if (name.startsWith(this.name + ".")) {
            String finalName = name = name.substring(this.name.length() + 1);
            return this.getChildren().stream().map(x -> x.findConfig(finalName)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public Collection<Choice> getChildren() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Choice getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Choice parent) {
        this.parent = (AbstractChoice)parent;
    }

    @Override
    public void replace(Choice c) {
        if (this.parent != null && c != null && this.name.equals(c.getName()) && this.parent.getChildren() != null) {
            this.parent.replaceChild(this, c);
        }
    }

    protected void replaceChild(Choice<O> oldChoice, Choice<O> newChoice) {
        throw new UnsupportedOperationException("replaceChild should have been overridden by a specific implementation of AbstractCoice");
    }
}

