/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import science.aist.machinelearning.core.Gene;
import science.aist.machinelearning.core.ProblemGene;

@NodeEntity
public class SolutionGene<ST, PT>
extends Gene<ST> {
    @Id
    private Long id;
    private String description;
    @Relationship(type="SOLVES", direction="OUTGOING")
    private List<ProblemGene<PT>> problemGenes = new ArrayList<ProblemGene<PT>>();

    public SolutionGene() {
    }

    public SolutionGene(ST gene) {
        this.gene = gene;
    }

    public SolutionGene(ST gene, List<ProblemGene<PT>> problemGenes) {
        this.gene = gene;
        this.problemGenes = problemGenes;
        this.description = this.toString();
    }

    public void addProblemGene(ProblemGene<PT> problemGene) {
        if (this.problemGenes == null) {
            this.problemGenes = new ArrayList<ProblemGene<PT>>();
        }
        this.problemGenes.add(problemGene);
        this.description = this.toString();
    }

    public List<ProblemGene<PT>> getProblemGenes() {
        return this.problemGenes;
    }

    public void setProblemGenes(List<ProblemGene<PT>> problemGenes) {
        this.problemGenes = problemGenes;
        this.description = this.toString();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (this.gene != null) {
            text = new StringBuilder("[gene: " + this.gene + ", problems: [");
            if (this.problemGenes != null) {
                for (ProblemGene<PT> problemGene : this.problemGenes) {
                    text.append(problemGene.toString()).append(",");
                }
            }
            text.append("]");
        }
        return text.toString();
    }

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }
}

