/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.fitness.Cachet;

@NodeEntity
public class Solution<ST, PT>
implements Serializable {
    protected double quality;
    @Relationship(type="QUALITY", direction="OUTGOING")
    protected List<Cachet> cachets = new ArrayList<Cachet>();
    @Relationship(type="GENE", direction="OUTGOING")
    protected List<SolutionGene<ST, PT>> solutionGenes = new ArrayList<SolutionGene<ST, PT>>();
    @Id
    private Long id;

    public Solution() {
    }

    public Solution(Solution<ST, PT> solution) {
        this.setQuality(solution.getQuality());
        this.setCachets(solution.getCachets());
        if (solution.getSolutionGenes() != null) {
            for (SolutionGene<ST, PT> gene : solution.getSolutionGenes()) {
                this.getSolutionGenes().add(new SolutionGene(gene.getGene(), gene.getProblemGenes()));
            }
        }
    }

    public void addGene(SolutionGene<ST, PT> solutionGene) {
        if (this.solutionGenes == null) {
            this.solutionGenes = new ArrayList<SolutionGene<ST, PT>>();
        }
        this.solutionGenes.add(solutionGene);
    }

    public double getQuality() {
        return this.quality;
    }

    public void setQuality(double quality) {
        this.quality = quality;
    }

    public List<Cachet> getCachets() {
        return this.cachets;
    }

    public void setCachets(List<Cachet> cachets) {
        this.cachets = cachets;
    }

    public List<SolutionGene<ST, PT>> getSolutionGenes() {
        return this.solutionGenes;
    }

    public void setSolutionGenes(List<SolutionGene<ST, PT>> solutionGenes) {
        this.solutionGenes = solutionGenes;
    }

    public String toHumanReadableString() {
        StringBuilder text = new StringBuilder("[Solution, Genes = [");
        if (this.solutionGenes != null) {
            for (SolutionGene<ST, PT> solutionGene : this.solutionGenes) {
                text.append(solutionGene.toString()).append(",");
            }
        }
        text.append("]");
        return text.toString();
    }

    public Long getId() {
        return this.id;
    }

    public String toString() {
        return this.toHumanReadableString();
    }

    public void adopt(Solution s) {
        this.id = s.id;
        this.quality = s.quality;
        this.cachets = s.cachets;
    }
}

