/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import science.aist.machinelearning.core.ProblemGene;

@NodeEntity
public class Problem<PT>
implements Serializable {
    @Id
    private Long id;
    @Relationship(type="GENE", direction="OUTGOING")
    private List<ProblemGene<PT>> problemGenes = new ArrayList<ProblemGene<PT>>();

    public Problem() {
    }

    public Problem(List<ProblemGene<PT>> problemGenes) {
        this.problemGenes = problemGenes;
    }

    public String getProblemSize() {
        return this.problemGenes != null ? String.valueOf(this.problemGenes.size()) : "NULL";
    }

    public String toHumanReadableString() {
        StringBuilder text = new StringBuilder("[Problem, Genes = [");
        for (ProblemGene<PT> problemGene : this.problemGenes) {
            text.append(problemGene.toString()).append(",");
        }
        text.append("]");
        return text.toString();
    }

    public List<ProblemGene<PT>> getProblemGenes() {
        return this.problemGenes;
    }

    public void setProblemGenes(List<ProblemGene<PT>> problemGenes) {
        this.problemGenes = problemGenes;
    }

    public Long getId() {
        return this.id;
    }
}

