/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;
import science.aist.machinelearning.core.Algorithm;
import science.aist.machinelearning.core.analytics.Analytics;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.mapping.SolutionCreator;
import science.aist.machinelearning.core.options.Descriptor;

public abstract class AbstractAlgorithm<ST, PT>
implements Algorithm<ST, PT> {
    protected Evaluator<ST, PT> evaluator;
    protected SolutionCreator<ST, PT> solutionCreator;
    protected Analytics analytics;

    public Evaluator<ST, PT> getEvaluator() {
        return this.evaluator;
    }

    @Required
    public void setEvaluator(Evaluator<ST, PT> evaluator) {
        this.evaluator = evaluator;
    }

    public SolutionCreator<ST, PT> getSolutionCreator() {
        return this.solutionCreator;
    }

    @Required
    public void setSolutionCreator(SolutionCreator<ST, PT> solutionCreator) {
        this.solutionCreator = solutionCreator;
    }

    @Override
    public Analytics getAnalytics() {
        return this.analytics;
    }

    @Override
    public void setAnalytics(Analytics analytics) {
        this.analytics = analytics;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("evaluator", new Descriptor<Evaluator<ST, PT>>(this.evaluator));
        options.put("solutionCreator", new Descriptor<SolutionCreator<ST, PT>>(this.solutionCreator));
        options.put("analytics", new Descriptor<Analytics>(this.analytics));
        options.putAll(this.getSpecificOptions());
        return options;
    }

    protected abstract Map<String, Descriptor> getSpecificOptions();

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            switch (name) {
                case "evaluator": {
                    this.setEvaluator((Evaluator)descriptor.getValue());
                    break;
                }
                case "solutionCreator": {
                    this.setSolutionCreator((SolutionCreator)descriptor.getValue());
                    break;
                }
                case "analytics": {
                    this.setAnalytics((Analytics)descriptor.getValue());
                    break;
                }
                default: {
                    return this.setSpecificOption(name, descriptor);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected abstract boolean setSpecificOption(String var1, Descriptor var2);
}

