/*
 * Copyright (c) 2021 the original author or authors.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package science.aist.machinelearning.analytics.graph.nodes;

import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;

import java.util.HashMap;
import java.util.Map;

/**
 * Describes a single step of a machine learning algorithm in human readable form
 *
 * @author Oliver Krauss
 * @since 1.0
 */
@NodeEntity
public class StepNode {

    /**
     * Links to following step taken by algorithm (last step has no next)
     */
    @Relationship(type = "NEXT", direction = Relationship.OUTGOING)
    StepNode nextStep;
    /**
     * Id generated by database
     */
    @Id
    private Long id;
    /**
     * Time the step was executed
     */
    private String time;
    /**
     * Generic parameters logged by algorithm, dependent on algorithm used
     */
    private Map<String, Object> parameters = new HashMap<>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Map<String, Object> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, Object value) {
        parameters.put(name, value);
    }

    public StepNode getNextStep() {
        return nextStep;
    }

    public void setNextStep(StepNode nextStep) {
        this.nextStep = nextStep;
    }
}
