/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.analytics;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.log4j.Logger;
import science.aist.machinelearning.analytics.space.DateTimeFormats;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.ProblemGene;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.analytics.Analytics;

public class CSVAnalytics
implements Analytics {
    private static final Logger logger = Logger.getLogger(CSVAnalytics.class);
    private final DateTimeFormatter formatter = DateTimeFormats.getDateTimeFormat();
    private String path;
    private PrintWriter file;
    private int steps = 0;

    public void startAnalytics() {
        try {
            String filename = (this.path != null ? this.path : "") + "AlgRun_" + LocalDateTime.now().format(this.formatter) + ".csv";
            File f = new File(filename);
            int i = 1;
            while (f.exists()) {
                f = new File(filename.substring(0, filename.length() - 4) + "_" + i + filename.substring(filename.length() - 4));
                ++i;
            }
            f.createNewFile();
            this.file = new PrintWriter(f, StandardCharsets.UTF_8);
            this.file.println("start;" + LocalDateTime.now());
            this.steps = 0;
            logger.info((Object)("Created new file for analytics: " + f.getAbsolutePath()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Failed to create file due to mapping error", (Throwable)e);
            this.finishAnalytics();
        }
        catch (IOException e) {
            logger.error((Object)"Could not create file", (Throwable)e);
            this.finishAnalytics();
        }
    }

    public void logParam(String name, String value) {
        this.file.println(name + ";" + value);
    }

    public void logAlgorithmStepHeaders(List<String> names) {
        if (names == null || names.isEmpty()) {
            return;
        }
        StringBuilder line = new StringBuilder("step;time;");
        for (String header : names) {
            line.append(header).append(";");
        }
        line = new StringBuilder(line.substring(0, line.length() - 1));
        this.file.println(line);
    }

    public void logAlgorithmStep(List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        StringBuilder line = new StringBuilder(this.steps + ";" + LocalDateTime.now() + ";");
        for (String header : values) {
            line.append(header).append(";");
        }
        line = new StringBuilder(line.substring(0, line.length() - 1));
        this.file.println(line);
        ++this.steps;
    }

    public <P> void logProblem(Problem<P> problem) {
        this.file.println("Problem: ");
        StringBuilder text = new StringBuilder("[");
        for (ProblemGene gene : problem.getProblemGenes()) {
            text.append(gene.toString()).append(", ");
        }
        text.append("]");
        this.file.println(text);
    }

    public <GT, P> void logSolution(Solution<GT, P> solution) {
        this.file.println("Solution: ");
        this.file.println(solution.toHumanReadableString());
    }

    public void finishAnalytics() {
        logger.info((Object)"Saved file for analytics");
        this.file.flush();
        this.file.close();
        this.file = null;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

