/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.mutation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.mutation.RandomNGenesMutator;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;

public abstract class RollbackRandomNGenesMutator<ST, PT>
extends RandomNGenesMutator<ST, PT> {
    @Override
    public Solution<ST, PT> mutate(Solution<ST, PT> solution) {
        if (solution == null) {
            return null;
        }
        solution = new Solution(solution);
        ArrayList<Integer> availableIndex = new ArrayList<Integer>();
        for (int i = 0; i < solution.getSolutionGenes().size(); ++i) {
            availableIndex.add(i);
        }
        double previousQuality = solution.getQuality();
        ArrayList oldCachets = new ArrayList(solution.getCachets());
        HashMap<Integer, SolutionGene> previousGenes = new HashMap<Integer, SolutionGene>();
        int counter = 0;
        while (counter++ < this.getMutationsPerSolution() && availableIndex.size() > 0) {
            int index = (Integer)availableIndex.remove(this.getR().nextInt(availableIndex.size()));
            SolutionGene gene = (SolutionGene)solution.getSolutionGenes().get(index);
            previousGenes.put(index, new SolutionGene(gene.getGene(), gene.getProblemGenes()));
            solution.getSolutionGenes().set(index, this.createGeneByMutation(gene));
        }
        this.getEvaluator().evaluateQuality(solution);
        if (previousQuality <= solution.getQuality()) {
            solution.setQuality(previousQuality);
            solution.setCachets(oldCachets);
            for (Map.Entry entry : previousGenes.entrySet()) {
                solution.getSolutionGenes().set((Integer)entry.getKey(), (SolutionGene)entry.getValue());
            }
        }
        return solution;
    }
}

