/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.mutation;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import science.aist.machinelearning.algorithm.mutation.EvaluatingMutator;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.SolutionGene;
import science.aist.machinelearning.core.options.Descriptor;

public abstract class RandomNGenesMutator<ST, PT>
extends EvaluatingMutator<ST, PT> {
    private final Random r = new Random();
    private Integer mutationsPerSolution = 1;

    @Override
    public Solution<ST, PT> mutate(Solution<ST, PT> solution) {
        if (solution == null) {
            return null;
        }
        Solution mutation = new Solution();
        ArrayList<Integer> availableIndex = new ArrayList<Integer>();
        int counter = 0;
        for (SolutionGene gene : solution.getSolutionGenes()) {
            mutation.addGene(new SolutionGene(gene.getGene(), gene.getProblemGenes()));
            availableIndex.add(counter++);
        }
        counter = 0;
        while (counter++ < this.getMutationsPerSolution() && availableIndex.size() > 0) {
            int index = (Integer)availableIndex.remove(this.r.nextInt(availableIndex.size()));
            mutation.getSolutionGenes().set(index, this.createGeneByMutation((SolutionGene)mutation.getSolutionGenes().get(index)));
        }
        this.getEvaluator().evaluateQuality(mutation);
        return mutation.getQuality() < solution.getQuality() ? mutation : new Solution(solution);
    }

    protected abstract SolutionGene<ST, PT> createGeneByMutation(SolutionGene<ST, PT> var1);

    public Integer getMutationsPerSolution() {
        return this.mutationsPerSolution;
    }

    public void setMutationsPerSolution(Integer mutationsPerSolution) {
        this.mutationsPerSolution = mutationsPerSolution;
    }

    public Random getR() {
        return this.r;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        Map<String, Descriptor> options = super.getOptions();
        options.put("mutationsPerSolution", new Descriptor((Object)this.mutationsPerSolution));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("mutationsPerSolution")) {
                this.setMutationsPerSolution((Integer)descriptor.getValue());
            } else {
                super.setOption(name, descriptor);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

