/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.visualisation.jgraphx;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import science.aist.machinelearning.algorithm.gp.CacheableGPGraphNode;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.ValueContainer;

public class GPVisualisation
extends JFrame {
    private int nodeWidth = 80;
    private int nodeHeight = 30;
    private int maximumDepth = 0;
    private Map<GPGraphNode, Object> drawnNodes = null;

    public GPVisualisation() throws HeadlessException {
    }

    public GPVisualisation(int nodeWidth, int nodeHeight) throws HeadlessException {
        this.nodeWidth = nodeWidth;
        this.nodeHeight = nodeHeight;
    }

    public void drawGPGraph(GPGraphNode node) {
        this.maximumDepth = 0;
        this.drawnNodes = new HashMap<GPGraphNode, Object>();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mxGraph graph = new mxGraph();
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        this.drawNode(node, null, graph, 0, 0.0, screenSize.width, parent);
        graph.getModel().endUpdate();
        mxGraphComponent graphComponent = new mxGraphComponent(graph);
        this.getContentPane().add((Component)graphComponent);
        this.setDefaultCloseOperation(1);
        this.setSize(screenSize.width, (this.maximumDepth + 1) * (this.nodeHeight + 2) + 60);
        this.setVisible(true);
        while (this.isVisible()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void drawNode(GPGraphNode node, Object previousNode, mxGraph graph, int depth, double startWidth, double endWidth, Object parent) {
        if (depth > this.maximumDepth) {
            this.maximumDepth = depth;
        }
        Object className = node.getClass().getSimpleName();
        className = ((String)className).substring(0, ((String)className).length() - 4);
        if (node instanceof ValueContainer) {
            ValueContainer value = (ValueContainer)((Object)node);
            className = (String)className + "\n(" + value.getValue() + ")";
        }
        Object newNode = node instanceof CacheableGPGraphNode && ((CacheableGPGraphNode)node).isCached() ? graph.insertVertex(parent, null, className, (endWidth - startWidth) / 2.0 + startWidth, (double)(depth * (this.nodeHeight + 2)), (double)this.nodeWidth, (double)this.nodeHeight, "fillColor=green") : graph.insertVertex(parent, null, className, (endWidth - startWidth) / 2.0 + startWidth, (double)(depth * (this.nodeHeight + 2)), (double)this.nodeWidth, (double)this.nodeHeight);
        this.drawnNodes.put(node, newNode);
        if (previousNode != null) {
            graph.insertEdge(parent, null, (Object)"", previousNode, newNode);
        }
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode casted = (FunctionalGPGraphNode)node;
            double currentChild = 0.0;
            double children = casted.getChildNodes().size();
            double widthPart = (endWidth - startWidth) / children;
            for (GPGraphNode child : casted.getChildNodes()) {
                if (this.drawnNodes.containsKey(child)) {
                    graph.insertEdge(parent, null, (Object)"", newNode, this.drawnNodes.get(child));
                    continue;
                }
                this.drawNode(child, newNode, graph, depth + 1, startWidth + currentChild * widthPart, startWidth + (currentChild + 1.0) * widthPart, parent);
                currentChild += 1.0;
            }
        }
    }

    public void setNodeWidth(int nodeWidth) {
        this.nodeWidth = nodeWidth;
    }

    public void setNodeHeight(int nodeHeight) {
        this.nodeHeight = nodeHeight;
    }
}

