/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.util;

import java.util.ArrayList;
import java.util.Collection;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;

public class GPValidator {
    public static boolean validateGraph(GPGraphNode node) {
        return GPValidator.validateGraph(node, new ArrayList<GPGraphNode>(), true);
    }

    public static boolean validateGraphLoopsOnly(GPGraphNode node) {
        return GPValidator.validateGraph(node, new ArrayList<GPGraphNode>(), false);
    }

    private static boolean validateGraph(GPGraphNode node, Collection<GPGraphNode> previousNodes, boolean fullCheck) {
        if (node instanceof FunctionalGPGraphNode) {
            previousNodes.add(node);
            FunctionalGPGraphNode cast = (FunctionalGPGraphNode)node;
            if (fullCheck && !cast.checkValidity()) {
                return false;
            }
            for (GPGraphNode child : cast.getChildNodes()) {
                if (!previousNodes.contains(child) && (!(child instanceof FunctionalGPGraphNode) || GPValidator.validateGraph(child, previousNodes, fullCheck))) continue;
                return false;
            }
            previousNodes.remove(node);
        }
        return true;
    }
}

