/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import science.aist.machinelearning.algorithm.gp.CacheableGPGraphNode;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.AddNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.AndNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.ConstantBooleanNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.ConstantDoubleNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.DivideNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.ExponentiateNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.LessThanNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.MultiplyNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.OrNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.SquareRootNode;
import science.aist.machinelearning.algorithm.gp.nodes.math.SubtractNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.CacheTraderCollectionNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.CacheTraderNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.IfThenElseNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;

public class GPTrim {
    public static ResultNode trimGraph(ResultNode node) {
        ResultNode graphToTrim = BasicNodeUtil.deepCopyForGraph(node);
        GPTrim.trimGraph(node, new ArrayList<GPGraphNode>());
        return graphToTrim;
    }

    private static GPGraphNode trimGraph(GPGraphNode node, Collection<GPGraphNode> visitedNodes) {
        if (node instanceof FunctionalGPGraphNode) {
            CacheableGPGraphNode node2;
            CacheableGPGraphNode node1;
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)node;
            ArrayList<GPGraphNode> children = castedNode.getChildNodes();
            ListIterator<GPGraphNode> childIterator = children.listIterator();
            while (childIterator.hasNext()) {
                GPGraphNode child = childIterator.next();
                if (visitedNodes.contains(child)) continue;
                visitedNodes.add(child);
                childIterator.set(GPTrim.trimGraph(child, visitedNodes));
            }
            if (castedNode instanceof CacheTraderNode || castedNode instanceof CacheTraderCollectionNode) {
                if (!(children.get(0) instanceof CacheableGPGraphNode && ((CacheableGPGraphNode)children.get(0)).isCached() || children.get(1) instanceof CacheableGPGraphNode && ((CacheableGPGraphNode)children.get(1)).isCached())) {
                    return children.get(0);
                }
            } else if (castedNode instanceof OrNode || castedNode instanceof AndNode) {
                if (children.get(0) instanceof ConstantBooleanNode && children.get(1) instanceof ConstantBooleanNode) {
                    node1 = (ConstantBooleanNode)children.get(0);
                    node2 = (ConstantBooleanNode)children.get(1);
                    if (!node1.isCached() && !node2.isCached()) {
                        ConstantBooleanNode newNode = new ConstantBooleanNode();
                        newNode.setValue(castedNode instanceof OrNode ? ((ConstantBooleanNode)node1).getValue().booleanValue() || ((ConstantBooleanNode)node2).getValue().booleanValue() : ((ConstantBooleanNode)node1).getValue() != false && ((ConstantBooleanNode)node2).getValue() != false);
                        return newNode;
                    }
                }
            } else if (castedNode instanceof LessThanNode) {
                if (children.get(0) instanceof ConstantDoubleNode && children.get(1) instanceof ConstantDoubleNode) {
                    node1 = (ConstantDoubleNode)children.get(0);
                    node2 = (ConstantDoubleNode)children.get(1);
                    if (!node1.isCached() && !node2.isCached()) {
                        ConstantBooleanNode newNode = new ConstantBooleanNode();
                        newNode.setValue(((ConstantDoubleNode)node1).getValue() < ((ConstantDoubleNode)node2).getValue());
                        return newNode;
                    }
                }
            } else if (castedNode instanceof AddNode || castedNode instanceof SubtractNode || castedNode instanceof MultiplyNode || castedNode instanceof DivideNode || castedNode instanceof ExponentiateNode || castedNode instanceof SquareRootNode) {
                if (children.get(0) instanceof ConstantDoubleNode && children.get(1) instanceof ConstantDoubleNode) {
                    node1 = (ConstantDoubleNode)children.get(0);
                    node2 = (ConstantDoubleNode)children.get(1);
                    if (!node1.isCached() && !node2.isCached()) {
                        ConstantDoubleNode newNode = new ConstantDoubleNode();
                        if (castedNode instanceof AddNode) {
                            newNode.setValue(((ConstantDoubleNode)node1).getValue() + ((ConstantDoubleNode)node2).getValue());
                        } else if (castedNode instanceof SubtractNode) {
                            newNode.setValue(((ConstantDoubleNode)node1).getValue() - ((ConstantDoubleNode)node2).getValue());
                        } else if (castedNode instanceof MultiplyNode) {
                            newNode.setValue(((ConstantDoubleNode)node1).getValue() * ((ConstantDoubleNode)node2).getValue());
                        } else if (castedNode instanceof DivideNode) {
                            newNode.setValue(((ConstantDoubleNode)node1).getValue() / (((ConstantDoubleNode)node2).getValue() == 0.0 ? 1.0 : ((ConstantDoubleNode)node2).getValue()));
                        } else if (castedNode instanceof ExponentiateNode) {
                            newNode.setValue(Math.pow(((ConstantDoubleNode)node1).getValue(), ((ConstantDoubleNode)node2).getValue()));
                        } else {
                            newNode.setValue(Math.pow(((ConstantDoubleNode)node1).getValue(), 1.0 / ((ConstantDoubleNode)node2).getValue()));
                        }
                        return newNode;
                    }
                }
            } else if (castedNode instanceof IfThenElseNode && children.get(0) instanceof ConstantBooleanNode && !(node1 = (ConstantBooleanNode)children.get(0)).isCached()) {
                if (((ConstantBooleanNode)node1).getValue().booleanValue()) {
                    return children.get(1);
                }
                return children.get(2);
            }
        }
        return node;
    }
}

