/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import science.aist.machinelearning.algorithm.gp.CacheableGPGraphNode;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalCollectionGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.algorithm.gp.util.GPValidator;
import science.aist.machinelearning.core.options.Descriptor;
import science.aist.machinelearning.core.options.ListDescriptor;
import science.aist.machinelearning.core.options.MinMaxDescriptor;

public class GPRepair {
    private final Random r = new Random();
    private int maxDepth = 10;
    private int minDepth = 1;
    private double cachedNodeProbability = 0.2;
    private double reuseNodeProbability = 0.2;
    private boolean newlyCreated = false;

    public GPRepair() {
    }

    public GPRepair(int maxDepth, int minDepth, double cachedNodeProbability, double reuseNodeProbability) {
        this.maxDepth = maxDepth;
        this.minDepth = minDepth;
        this.cachedNodeProbability = cachedNodeProbability;
        this.reuseNodeProbability = reuseNodeProbability;
    }

    public void repairGraph(GPGraphNode node, Map<Class, ArrayList<GPGraphNode>> validNodes, Map<Class, ArrayList<GPGraphNode>> terminals, Map<Class, ArrayList<GPGraphNode>> functionals, Map<Class, Map<String, Descriptor>> settings) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Map<Class, ArrayList<GPGraphNode>> existingNodes = BasicNodeUtil.nodesWithReturnType(node);
        this.repairGraph(node, validNodes, terminals, functionals, existingNodes, new ArrayList<GPGraphNode>(), 0, settings);
    }

    private void repairGraph(GPGraphNode node, Map<Class, ArrayList<GPGraphNode>> validNodes, Map<Class, ArrayList<GPGraphNode>> terminals, Map<Class, ArrayList<GPGraphNode>> functionals, Map<Class, ArrayList<GPGraphNode>> existingNodes, Collection<GPGraphNode> visitedNodes, int currentDepth, Map<Class, Map<String, Descriptor>> settings) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)node;
            if (!castedNode.checkValidity()) {
                this.addGraphSettings(castedNode, settings.get(castedNode.getClass()));
                boolean collection = false;
                ArrayList<GPGraphNode> children = castedNode.getChildNodes();
                int currentPos = 0;
                ArrayList<Class> classes = castedNode.requiredClassesForChildren();
                for (Class clazz : classes) {
                    if (collection || children.size() <= currentPos || !clazz.isAssignableFrom(children.get(currentPos).simpleReturnType().getClass())) {
                        GPGraphNode newNode = null;
                        if (clazz.equals(Object.class)) {
                            ArrayList<Class> keys = new ArrayList<Class>(validNodes.keySet());
                            while (clazz.equals(Collection.class) || clazz.equals(Object.class)) {
                                clazz = keys.get(this.r.nextInt(keys.size()));
                            }
                        }
                        if (collection) {
                            collection = false;
                            newNode = this.pickNodeDependingOnClass(validNodes, terminals, functionals, existingNodes, castedNode, currentDepth, clazz, true);
                        } else if (clazz.equals(Collection.class)) {
                            collection = true;
                        } else {
                            newNode = this.pickNodeDependingOnClass(validNodes, terminals, functionals, existingNodes, castedNode, currentDepth, clazz, false);
                        }
                        if (!collection) {
                            this.addGraphSettings(newNode, settings.get(newNode.getClass()));
                            castedNode.getChildNodes().add(currentPos, newNode);
                            if (this.newlyCreated) {
                                this.newlyCreated = false;
                                if (!newNode.getClass().equals(ResultNode.class)) {
                                    ArrayList<GPGraphNode> nodesForSpecificClass;
                                    Class currentClass = newNode.simpleReturnType() instanceof Collection ? Collection.class : (newNode.simpleReturnType() instanceof Number ? Number.class : newNode.simpleReturnType().getClass());
                                    if (!existingNodes.containsKey(currentClass)) {
                                        existingNodes.put(currentClass, new ArrayList());
                                    }
                                    if (!(nodesForSpecificClass = existingNodes.get(currentClass)).contains(newNode)) {
                                        nodesForSpecificClass.add(newNode);
                                    }
                                }
                                if (this.r.nextDouble() <= this.cachedNodeProbability && newNode instanceof CacheableGPGraphNode) {
                                    ((CacheableGPGraphNode)newNode).setCached(true);
                                }
                            }
                        }
                    }
                    if (collection) continue;
                    ++currentPos;
                }
                classes.removeIf(c -> c.equals(Collection.class));
                castedNode.setChildNodes(new ArrayList<GPGraphNode>(castedNode.getChildNodes().subList(0, classes.size())));
            }
            for (GPGraphNode child : castedNode.getChildNodes()) {
                if (visitedNodes.contains(child)) continue;
                visitedNodes.add(child);
                this.repairGraph(child, validNodes, terminals, functionals, existingNodes, visitedNodes, currentDepth + 1, settings);
            }
        }
    }

    private GPGraphNode pickNodeDependingOnClass(Map<Class, ArrayList<GPGraphNode>> validNodes, Map<Class, ArrayList<GPGraphNode>> terminals, Map<Class, ArrayList<GPGraphNode>> functionals, Map<Class, ArrayList<GPGraphNode>> existingNodes, FunctionalGPGraphNode previousNode, int currentDepth, Class clazz, boolean collection) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<GPGraphNode> nodesToPickFrom;
        GPGraphNode node = null;
        if (currentDepth < this.minDepth) {
            node = this.createNodeUsingNodeList(functionals, clazz, collection);
        } else if (this.r.nextInt(this.maxDepth) < currentDepth) {
            node = this.createNodeUsingNodeList(terminals, clazz, collection);
        } else if (this.r.nextDouble() <= this.reuseNodeProbability && (nodesToPickFrom = existingNodes.get(collection ? Collection.class : clazz)) != null) {
            GenericFunctionalCollectionGPGraphNode castedNode;
            node = nodesToPickFrom.get(this.r.nextInt(nodesToPickFrom.size()));
            if (collection && node instanceof GenericFunctionalCollectionGPGraphNode && !(castedNode = (GenericFunctionalCollectionGPGraphNode)node).getClazz().equals(clazz)) {
                node = null;
            }
            if (node != null) {
                previousNode.addChildNode(node);
                boolean remove = !GPValidator.validateGraphLoopsOnly(node);
                previousNode.getChildNodes().remove(node);
                if (remove) {
                    node = null;
                }
            }
        }
        if (node == null) {
            node = this.createNodeUsingNodeList(validNodes, clazz, collection);
        }
        return node;
    }

    private GPGraphNode createNodeUsingNodeList(Map<Class, ArrayList<GPGraphNode>> nodesToPickFrom, Class clazz, boolean collection) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        List validNodes = collection ? (List)nodesToPickFrom.get(Collection.class) : (List)nodesToPickFrom.get(clazz);
        if (validNodes != null && !validNodes.isEmpty()) {
            GPGraphNode chosen = (GPGraphNode)validNodes.get(this.r.nextInt(validNodes.size()));
            this.newlyCreated = true;
            if (chosen instanceof GenericFunctionalCollectionGPGraphNode || chosen instanceof GenericFunctionalGPGraphNode) {
                return (GPGraphNode)chosen.getClass().getConstructor(Class.class).newInstance(clazz);
            }
            return (GPGraphNode)chosen.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return null;
    }

    private void addGraphSettings(GPGraphNode node, Map<String, Descriptor> descriptorMap) {
        if (descriptorMap == null) {
            return;
        }
        for (Map.Entry<String, Descriptor> entry : descriptorMap.entrySet()) {
            MinMaxDescriptor descriptor;
            if (entry.getValue().getValue() != null) {
                node.setOption(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof MinMaxDescriptor) {
                MinMaxDescriptor casted;
                descriptor = (MinMaxDescriptor)entry.getValue();
                if (descriptor.getMin().getClass() == Integer.class) {
                    casted = descriptor;
                    node.setOption(entry.getKey(), new Descriptor((Object)(this.r.nextInt((Integer)casted.getMax() - (Integer)casted.getMin()) + (Integer)casted.getMin())));
                    continue;
                }
                if (descriptor.getMin().getClass() == Double.class) {
                    casted = descriptor;
                    node.setOption(entry.getKey(), new Descriptor((Object)((Double)casted.getMin() + ((Double)casted.getMax() - (Double)casted.getMin()) * this.r.nextDouble())));
                    continue;
                }
                if (descriptor.getMin().getClass() != Float.class) continue;
                casted = descriptor;
                node.setOption(entry.getKey(), new Descriptor((Object)Float.valueOf(((Float)casted.getMin()).floatValue() + (((Float)casted.getMax()).floatValue() - ((Float)casted.getMin()).floatValue()) * this.r.nextFloat())));
                continue;
            }
            descriptor = (ListDescriptor)entry.getValue();
            node.setOption(entry.getKey(), new Descriptor(descriptor.getValueList().get(this.r.nextInt(descriptor.getValueList().size()))));
        }
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public double getCachedNodeProbability() {
        return this.cachedNodeProbability;
    }

    public void setCachedNodeProbability(double cachedNodeProbability) {
        this.cachedNodeProbability = cachedNodeProbability;
    }

    public double getReuseNodeProbability() {
        return this.reuseNodeProbability;
    }

    public void setReuseNodeProbability(double reuseNodeProbability) {
        this.reuseNodeProbability = reuseNodeProbability;
    }

    public Random getR() {
        return this.r;
    }
}

