/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.CacheableGPGraphNode;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GPGraphNode;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalCollectionGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.InterruptibleNode;
import science.aist.machinelearning.algorithm.gp.nodes.basic.ResultNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.CrossoverNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.MutatorNode;
import science.aist.machinelearning.algorithm.gp.nodes.heuristic.SolutionCreatorNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.CollectionMergeNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.ForCollectionNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.ForNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.WhileCollectionNode;
import science.aist.machinelearning.algorithm.gp.nodes.programming.WhileNode;
import science.aist.machinelearning.core.Solution;

public class BasicNodeUtil {
    public static <T> void removeAllGivenValueFromCollection(Collection<T> collection, T remove) {
        collection.removeIf(next -> next == remove);
    }

    public static ResultNode deepCopyForGraph(ResultNode originalRoot) {
        ResultNode root = new ResultNode();
        try {
            BasicNodeUtil.reconstructNode(originalRoot, root, new HashMap<GPGraphNode, GPGraphNode>());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return root;
    }

    private static void reconstructNode(GPGraphNode originalNode, GPGraphNode newNode, Map<GPGraphNode, GPGraphNode> oldToNew) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        newNode.setOptions(originalNode.getOptions());
        if (originalNode instanceof CacheableGPGraphNode && ((CacheableGPGraphNode)originalNode).isCached()) {
            ((CacheableGPGraphNode)newNode).setCached(true);
        }
        if (originalNode instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedOriginalNode = (FunctionalGPGraphNode)originalNode;
            FunctionalGPGraphNode castedNewNode = (FunctionalGPGraphNode)newNode;
            for (GPGraphNode node : castedOriginalNode.getChildNodes()) {
                if (!oldToNew.containsKey(node)) {
                    GPGraphNode newChild;
                    FunctionalGPGraphNode genericNode;
                    if (node instanceof GenericFunctionalGPGraphNode) {
                        genericNode = (GenericFunctionalGPGraphNode)node;
                        newChild = (GPGraphNode)node.getClass().getConstructor(Class.class).newInstance(((GenericFunctionalGPGraphNode)genericNode).getClazz());
                    } else if (node instanceof GenericFunctionalCollectionGPGraphNode) {
                        genericNode = (GenericFunctionalCollectionGPGraphNode)node;
                        newChild = (GPGraphNode)node.getClass().getConstructor(Class.class).newInstance(((GenericFunctionalCollectionGPGraphNode)genericNode).getClazz());
                    } else {
                        newChild = (GPGraphNode)node.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    oldToNew.put(node, newChild);
                    BasicNodeUtil.reconstructNode(node, newChild, oldToNew);
                }
                castedNewNode.addChildNode(oldToNew.get(node));
            }
        }
    }

    public static int numberOfNodesInGraph(GPGraphNode node) {
        HashSet<GPGraphNode> nodes = new HashSet<GPGraphNode>();
        BasicNodeUtil.startCountingNodes(node, nodes);
        return nodes.size();
    }

    private static void startCountingNodes(GPGraphNode node, Collection<GPGraphNode> visitedNodes) {
        visitedNodes.add(node);
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castNode = (FunctionalGPGraphNode)node;
            for (GPGraphNode child : castNode.getChildNodes()) {
                if (visitedNodes.contains(child)) continue;
                BasicNodeUtil.startCountingNodes(child, visitedNodes);
            }
        }
    }

    public static int depthOfNode(ResultNode root, GPGraphNode nodeToFindDepth) {
        return BasicNodeUtil.depthOfNode(root, nodeToFindDepth, new ArrayList<GPGraphNode>(), 0);
    }

    private static int depthOfNode(GPGraphNode node, GPGraphNode find, Collection<GPGraphNode> visitedNodes, int currentDepth) {
        if (node == find) {
            return currentDepth;
        }
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)node;
            for (GPGraphNode child : castedNode.getChildNodes()) {
                if (visitedNodes.contains(child)) continue;
                visitedNodes.add(child);
                int depthOfChild = BasicNodeUtil.depthOfNode(child, find, visitedNodes, currentDepth + 1);
                if (depthOfChild == -1) continue;
                return depthOfChild;
            }
        }
        return -1;
    }

    public static Map<Class, ArrayList<GPGraphNode>> nodesWithReturnType(GPGraphNode node) {
        HashMap<Class, ArrayList<GPGraphNode>> returnTypes = new HashMap<Class, ArrayList<GPGraphNode>>();
        BasicNodeUtil.findAndSortByReturnType(node, returnTypes, new ArrayList<GPGraphNode>());
        return returnTypes;
    }

    private static void findAndSortByReturnType(GPGraphNode node, Map<Class, ArrayList<GPGraphNode>> foundNodes, ArrayList<GPGraphNode> visitedNodes) {
        if (!node.getClass().equals(ResultNode.class)) {
            ArrayList<GPGraphNode> nodesForSpecificClass;
            Class currentClass = node.simpleReturnType() instanceof Collection ? Collection.class : (node.simpleReturnType() instanceof Number ? Number.class : node.simpleReturnType().getClass());
            if (!foundNodes.containsKey(currentClass)) {
                foundNodes.put(currentClass, new ArrayList());
            }
            if (!(nodesForSpecificClass = foundNodes.get(currentClass)).contains(node)) {
                nodesForSpecificClass.add(node);
            }
        }
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)node;
            for (GPGraphNode child : castedNode.getChildNodes()) {
                if (visitedNodes.contains(child)) continue;
                BasicNodeUtil.findAndSortByReturnType(child, foundNodes, visitedNodes);
            }
        }
    }

    public static void resetCaches(GPGraphNode node) {
        BasicNodeUtil.resetCaches(node, new ArrayList<GPGraphNode>());
    }

    private static void resetCaches(GPGraphNode node, Collection<GPGraphNode> visitedNodes) {
        if (node instanceof CacheableGPGraphNode) {
            CacheableGPGraphNode castedNode = (CacheableGPGraphNode)node;
            castedNode.setCachedValue(null);
            if (castedNode instanceof FunctionalGPGraphNode) {
                FunctionalGPGraphNode functionalNode = (FunctionalGPGraphNode)castedNode;
                for (GPGraphNode child : functionalNode.getChildNodes()) {
                    if (visitedNodes.contains(child)) continue;
                    visitedNodes.add(child);
                    BasicNodeUtil.resetCaches(child, visitedNodes);
                }
            }
        }
    }

    public static void interruptGraph(GPGraphNode node, boolean value) {
        BasicNodeUtil.interruptGraph(node, new ArrayList<GPGraphNode>(), value);
    }

    private static void interruptGraph(GPGraphNode node, Collection<GPGraphNode> visitedNodes, boolean value) {
        if (node instanceof InterruptibleNode) {
            InterruptibleNode casted = (InterruptibleNode)((Object)node);
            casted.interrupt(value);
        }
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode functionalNode = (FunctionalGPGraphNode)node;
            for (GPGraphNode child : functionalNode.getChildNodes()) {
                if (visitedNodes.contains(child)) continue;
                visitedNodes.add(child);
                BasicNodeUtil.interruptGraph(child, visitedNodes, value);
            }
        }
    }

    public static int solutionsCreatedByGraph(GPGraphNode node) {
        if (node instanceof SolutionCreatorNode) {
            return 1;
        }
        if (node instanceof FunctionalGPGraphNode) {
            FunctionalGPGraphNode castedNode = (FunctionalGPGraphNode)node;
            ArrayList<GPGraphNode> children = castedNode.getChildNodes();
            if (node instanceof CollectionMergeNode) {
                return BasicNodeUtil.solutionsCreatedByGraph(children.get(0)) + BasicNodeUtil.solutionsCreatedByGraph(children.get(1));
            }
            if (node instanceof ForNode) {
                ForNode forNode = (ForNode)castedNode;
                if (forNode.getClazz().equals(Solution.class)) {
                    int max = ((Double)children.get(0).execute()).intValue();
                    return max * BasicNodeUtil.solutionsCreatedByGraph(children.get(1));
                }
            } else if (node instanceof ForCollectionNode) {
                ForCollectionNode forCollectionNode = (ForCollectionNode)castedNode;
                if (forCollectionNode.getClazz().equals(Solution.class)) {
                    int max = ((Double)children.get(0).execute()).intValue();
                    return max * BasicNodeUtil.solutionsCreatedByGraph(children.get(1));
                }
            } else if (node instanceof WhileNode) {
                WhileNode whileNode = (WhileNode)node;
                if (whileNode.getClazz().equals(Solution.class)) {
                    int max = whileNode.getMaxIterations();
                    return max * BasicNodeUtil.solutionsCreatedByGraph(children.get(1));
                }
            } else if (node instanceof WhileCollectionNode) {
                WhileCollectionNode whileCollectionNode = (WhileCollectionNode)node;
                if (whileCollectionNode.getClazz().equals(Solution.class)) {
                    int max = whileCollectionNode.getMaxIterations();
                    return max * BasicNodeUtil.solutionsCreatedByGraph(children.get(1));
                }
            } else {
                if (node instanceof MutatorNode || node instanceof CrossoverNode) {
                    return 1 + BasicNodeUtil.solutionsCreatedByGraph(children.get(0));
                }
                int solutions = 0;
                for (GPGraphNode child : children) {
                    solutions += BasicNodeUtil.solutionsCreatedByGraph(child);
                }
                return solutions;
            }
        }
        return 0;
    }
}

