/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.programming;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.InterruptibleNode;
import science.aist.machinelearning.core.options.Descriptor;

public class WhileNode<T>
extends GenericFunctionalGPGraphNode<T>
implements InterruptibleNode {
    private int maxIterations = 10000;
    private boolean interrupt = false;

    public WhileNode(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public boolean checkValidity() {
        return this.getChildNodes().size() == 2 && this.getChildNodes().get(0).simpleReturnType() instanceof Boolean && this.clazz.isAssignableFrom(this.getChildNodes().get(1).simpleReturnType().getClass());
    }

    @Override
    public ArrayList<Class> requiredClassesForChildren() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Boolean.class);
        classes.add(this.clazz);
        return classes;
    }

    @Override
    public T calculateValue() {
        T object = null;
        int i = 0;
        while (((Boolean)this.getChildNodes().get(0).execute()).booleanValue()) {
            object = this.getChildNodes().get(1).execute();
            if (!this.interrupt && (this.maxIterations == -1 || i++ < this.maxIterations)) continue;
            break;
        }
        return object;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("maxIterations", new Descriptor((Object)this.maxIterations));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("maxIterations")) {
                this.setMaxIterations((Integer)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void interrupt(boolean value) {
        this.interrupt = value;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

