/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.core.options.Descriptor;

public class RandomNode
extends FunctionalGPGraphNode<Double> {
    private final Random r = new Random();

    @Override
    public boolean checkValidity() {
        return this.getChildNodes().size() == 2 && this.getChildNodes().get(0).simpleReturnType() instanceof Number && this.getChildNodes().get(1).simpleReturnType() instanceof Number;
    }

    @Override
    public ArrayList<Class> requiredClassesForChildren() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Number.class);
        classes.add(Number.class);
        return classes;
    }

    @Override
    public Double calculateValue() {
        double rangeMin = (Double)this.getChildNodes().get(0).execute();
        double rangeMax = (Double)this.getChildNodes().get(1).execute();
        if (rangeMax < rangeMin) {
            double cup = rangeMax;
            rangeMax = rangeMin;
            rangeMin = cup;
        }
        return rangeMin + (rangeMax - rangeMin) * this.r.nextDouble();
    }

    @Override
    public Double simpleReturnType() {
        return 0.0;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        return new HashMap<String, Descriptor>();
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        return true;
    }
}

