/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.heuristic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalCollectionGPGraphNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.options.Descriptor;

public class TabuListNode
extends GenericFunctionalCollectionGPGraphNode<Solution> {
    private final LinkedList<Solution> tabuList = new LinkedList();
    private Evaluator evaluator;

    public TabuListNode(Class<Solution> clazz) {
        super(Solution.class);
    }

    @Override
    public boolean checkValidity() {
        if (this.getChildNodes().size() == 2 && this.getChildNodes().get(0).simpleReturnType() instanceof Number && this.getChildNodes().get(1) instanceof GenericFunctionalCollectionGPGraphNode && this.evaluator != null) {
            GenericFunctionalCollectionGPGraphNode node1Casted = (GenericFunctionalCollectionGPGraphNode)this.getChildNodes().get(1);
            return node1Casted.getClazz().equals(Solution.class);
        }
        return false;
    }

    @Override
    public ArrayList<Class> requiredClassesForChildren() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Number.class);
        classes.add(Collection.class);
        classes.add(Solution.class);
        return classes;
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("evaluator", new Descriptor((Object)this.evaluator));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("evaluator")) {
                this.setEvaluator((Evaluator)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Collection<Solution> calculateValue() {
        double tabuSize = Math.abs((Double)this.getChildNodes().get(0).execute());
        ArrayList solutions = (ArrayList)this.getChildNodes().get(1).execute();
        BasicNodeUtil.removeAllGivenValueFromCollection(solutions, null);
        for (Solution tabuSolution : this.tabuList) {
            solutions.remove(tabuSolution);
        }
        if (solutions.size() == 0) {
            return new ArrayList<Solution>();
        }
        Solution bestSolution = null;
        double quality = 0.0;
        for (Solution solution : solutions) {
            if (solution.getQuality() == 0.0) {
                this.evaluator.evaluateQuality(solution);
            }
            if (bestSolution != null && !(solution.getQuality() < quality)) continue;
            bestSolution = solution;
            quality = solution.getQuality();
        }
        this.tabuList.add(bestSolution);
        int i = 0;
        while ((double)i < (double)this.tabuList.size() - tabuSize) {
            this.tabuList.removeFirst();
            ++i;
        }
        return solutions;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }
}

