/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.heuristic;

import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.CacheableGPGraphNode;
import science.aist.machinelearning.core.Problem;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.mapping.SolutionCreator;
import science.aist.machinelearning.core.options.Descriptor;

public class SolutionCreatorNode
extends CacheableGPGraphNode<Solution> {
    private SolutionCreator solutionCreator;
    private Problem problem;
    private Evaluator evaluator;

    @Override
    public Solution calculateValue() {
        Solution solution = this.getSolutionCreator().createSolution(this.problem);
        this.evaluator.evaluateQuality(solution);
        return solution;
    }

    @Override
    public Solution simpleReturnType() {
        return new Solution();
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("creator", new Descriptor((Object)this.solutionCreator));
        options.put("problem", new Descriptor((Object)this.problem));
        options.put("evaluator", new Descriptor((Object)this.evaluator));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            switch (name) {
                case "creator": {
                    this.setSolutionCreator((SolutionCreator)descriptor.getValue());
                    break;
                }
                case "problem": {
                    this.setProblem((Problem)descriptor.getValue());
                    break;
                }
                case "evaluator": {
                    this.setEvaluator((Evaluator)descriptor.getValue());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public SolutionCreator getSolutionCreator() {
        return this.solutionCreator;
    }

    public void setSolutionCreator(SolutionCreator solutionCreator) {
        this.solutionCreator = solutionCreator;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }
}

