/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.heuristic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.mutation.Mutator;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.options.Descriptor;

public class MutatorNode
extends FunctionalGPGraphNode<Solution> {
    private Mutator mutator;
    private Evaluator evaluator = null;

    @Override
    public boolean checkValidity() {
        return this.getChildNodes().size() == 1 && this.getChildNodes().get(0).simpleReturnType() instanceof Solution && this.mutator != null && this.evaluator != null;
    }

    @Override
    public ArrayList<Class> requiredClassesForChildren() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Solution.class);
        return classes;
    }

    @Override
    public Solution calculateValue() {
        Solution solution = (Solution)this.getChildNodes().get(0).execute();
        if (solution == null) {
            return null;
        }
        if (solution.getQuality() == 0.0) {
            this.evaluator.evaluateQuality(solution);
        }
        return this.getMutator().mutate(solution);
    }

    @Override
    public Solution simpleReturnType() {
        return new Solution();
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("evaluator", new Descriptor((Object)this.evaluator));
        options.put("mutator", new Descriptor((Object)this.mutator));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("evaluator")) {
                this.setEvaluator((Evaluator)descriptor.getValue());
            } else if (name.equals("mutator")) {
                this.setMutator((Mutator)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public void setMutator(Mutator mutator) {
        this.mutator = mutator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }
}

