/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.heuristic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalCollectionGPGraphNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.options.Descriptor;

public class EvaluatorSolutionNode
extends FunctionalGPGraphNode<Solution> {
    private Evaluator evaluator;

    @Override
    public boolean checkValidity() {
        if (this.getChildNodes().size() == 1 && this.getChildNodes().get(0) instanceof GenericFunctionalCollectionGPGraphNode && this.evaluator != null) {
            GenericFunctionalCollectionGPGraphNode node1Casted = (GenericFunctionalCollectionGPGraphNode)this.getChildNodes().get(0);
            return node1Casted.getClazz().equals(Solution.class);
        }
        return false;
    }

    @Override
    public ArrayList<Class> requiredClassesForChildren() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Collection.class);
        classes.add(Solution.class);
        return classes;
    }

    @Override
    public Solution calculateValue() {
        Solution bestSolution = null;
        double quality = 0.0;
        ArrayList solutions = (ArrayList)this.getChildNodes().get(0).execute();
        BasicNodeUtil.removeAllGivenValueFromCollection(solutions, null);
        for (Solution solution : solutions) {
            if (solution.getQuality() == 0.0) {
                this.evaluator.evaluateQuality(solution);
            }
            if (bestSolution != null && !(solution.getQuality() < quality)) continue;
            bestSolution = solution;
            quality = solution.getQuality();
        }
        return bestSolution;
    }

    @Override
    public Solution simpleReturnType() {
        return new Solution();
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("evaluator", new Descriptor((Object)this.evaluator));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            if (name.equals("evaluator")) {
                this.setEvaluator((Evaluator)descriptor.getValue());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }
}

