/*
 * Decompiled with CFR 0.152.
 */
package science.aist.machinelearning.algorithm.gp.nodes.heuristic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import science.aist.machinelearning.algorithm.ga.Crossover;
import science.aist.machinelearning.algorithm.ga.Selector;
import science.aist.machinelearning.algorithm.gp.FunctionalGPGraphNode;
import science.aist.machinelearning.algorithm.gp.GenericFunctionalCollectionGPGraphNode;
import science.aist.machinelearning.algorithm.gp.util.BasicNodeUtil;
import science.aist.machinelearning.core.Solution;
import science.aist.machinelearning.core.fitness.Evaluator;
import science.aist.machinelearning.core.options.Descriptor;

public class CrossoverNode
extends FunctionalGPGraphNode<Solution> {
    private Crossover crossover = null;
    private Selector selector = null;
    private Evaluator evaluator = null;

    @Override
    public boolean checkValidity() {
        if (this.getChildNodes().size() == 1 && this.getChildNodes().get(0) instanceof GenericFunctionalCollectionGPGraphNode && this.crossover != null && this.selector != null && this.evaluator != null) {
            GenericFunctionalCollectionGPGraphNode node1Casted = (GenericFunctionalCollectionGPGraphNode)this.getChildNodes().get(0);
            return node1Casted.getClazz().equals(Solution.class);
        }
        return false;
    }

    @Override
    public ArrayList<Class> requiredClassesForChildren() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Collection.class);
        classes.add(Solution.class);
        return classes;
    }

    @Override
    public Solution calculateValue() {
        ArrayList solutions = (ArrayList)this.getChildNodes().get(0).execute();
        if (solutions == null) {
            return null;
        }
        BasicNodeUtil.removeAllGivenValueFromCollection(solutions, null);
        Solution crossoverSolution = this.getCrossover().breed((List)solutions, this.getSelector());
        this.evaluator.evaluateQuality(crossoverSolution);
        return crossoverSolution;
    }

    @Override
    public Solution simpleReturnType() {
        return new Solution();
    }

    @Override
    public Map<String, Descriptor> getOptions() {
        HashMap<String, Descriptor> options = new HashMap<String, Descriptor>();
        options.put("crossover", new Descriptor((Object)this.crossover));
        options.put("selector", new Descriptor((Object)this.selector));
        options.put("evaluator", new Descriptor((Object)this.evaluator));
        return options;
    }

    @Override
    public boolean setOption(String name, Descriptor descriptor) {
        try {
            switch (name) {
                case "crossover": {
                    this.setCrossover((Crossover)descriptor.getValue());
                    break;
                }
                case "selector": {
                    this.setSelector((Selector)descriptor.getValue());
                    break;
                }
                case "evaluator": {
                    this.setEvaluator((Evaluator)descriptor.getValue());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Crossover getCrossover() {
        return this.crossover;
    }

    public void setCrossover(Crossover crossover) {
        this.crossover = crossover;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }
}

